/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockPump;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityPumpTop;
import teamroots.embers.util.FluidUtil;
import teamroots.embers.util.Misc;

public class TileEntityPumpBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
IMechanicallyPowered,
IExtraDialInformation {
    public static final double EMBER_COST = ConfigMachine.PUMP.emberCost;
    int progress;
    int totalProgress;
    int lastProgress;
    EnumFacing front = EnumFacing.UP;
    public IEmberCapability capability = new DefaultEmberCapability();
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public TileEntityPumpBottom() {
        this.capability.setEmberCapacity(ConfigMachine.PUMP.capacity);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("front", this.front.func_176745_a());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.front = EnumFacing.func_82600_a((int)tag.func_74762_e("front"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY && facing != null) {
            return facing.func_176740_k() == this.front.func_176740_k();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY && facing != null && facing.func_176740_k() == this.front.func_176740_k()) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean attemptPump(BlockPos pos) {
        TileEntityPumpTop t;
        int filled;
        FluidStack stack;
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if ((state.func_177230_c() instanceof IFluidBlock && ((IFluidBlock)state.func_177230_c()).canDrain(this.field_145850_b, pos) || state.func_177230_c() instanceof BlockStaticLiquid) && (this.capability.getEmber() > 0.0 || this.isFreeFluid(state)) && (stack = FluidUtil.getFluid(this.field_145850_b, pos, state)) != null && (filled = (t = (TileEntityPumpTop)this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a())).getTank().fill(stack, false)) == stack.amount) {
            if (!this.field_145850_b.field_72995_K) {
                t.getTank().fill(stack, true);
            }
            t.func_70296_d();
            this.field_145850_b.func_175698_g(pos);
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                this.updateWater(pos.func_177972_a(facing));
            }
            return false;
        }
        return true;
    }

    private boolean isFreeFluid(IBlockState state) {
        FluidStack fluidStack = FluidUtil.getFluid(this.field_145850_b, this.func_174877_v(), state);
        if (fluidStack != null) {
            for (String s : ConfigMachine.PUMP.freeFluids) {
                if (!s.equals(fluidStack.getFluid().getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void updateWater(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_177230_c() instanceof IFluidBlock || state.func_177230_c() instanceof BlockLiquid) {
            state.func_177230_c().func_180650_b(this.field_145850_b, pos, state, new Random());
        }
    }

    public void func_73660_a() {
        boolean cancel;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_176754_o);
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        if (state.func_177230_c() instanceof BlockPump) {
            this.front = (EnumFacing)state.func_177229_b((IProperty)BlockPump.facing);
        }
        this.lastProgress = this.totalProgress;
        double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, this.upgrades);
        if (this.capability.getEmber() >= emberCost && !(cancel = UpgradeUtil.doWork(this, this.upgrades))) {
            int speed = (int)UpgradeUtil.getTotalSpeedModifier(this, this.upgrades);
            this.progress += speed;
            this.totalProgress += speed;
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
            this.capability.removeAmount(emberCost, true);
            if (this.progress > 400) {
                this.progress -= 400;
                boolean doContinue = true;
                if (!this.field_145850_b.field_72995_K) {
                    for (int r = 0; r < 6 && doContinue; ++r) {
                        for (int i = -r; i < r + 1 && doContinue; ++i) {
                            for (int j = -r; j < 1 && doContinue; ++j) {
                                for (int k = -r; k < r + 1 && doContinue; ++k) {
                                    doContinue = this.attemptPump(this.func_174877_v().func_177982_a(i, j - 1, k));
                                }
                            }
                        }
                    }
                }
                if (this.field_145850_b.field_72995_K) {
                    this.playSound(speed);
                }
            }
            this.func_70296_d();
        }
        this.func_70296_d();
    }

    private void playSound(int speed) {
        float pitch;
        SoundEvent sound;
        if (speed >= 20) {
            sound = SoundManager.PUMP_FAST;
            pitch = (float)speed / 20.0f;
        } else if (speed >= 10) {
            sound = SoundManager.PUMP_MID;
            pitch = (float)speed / 10.0f;
        } else {
            sound = SoundManager.PUMP_SLOW;
            pitch = speed;
        }
        this.field_145850_b.func_184133_a(Embers.proxy.getClientPlayer(), this.field_174879_c.func_177984_a(), sound, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Math.min(power / 2.0, 100.0);
    }

    @Override
    public double getMinimumPower() {
        return 2.0;
    }

    @Override
    public double getNominalSpeed() {
        return 10.0;
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }
}

