/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.register;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.block.IBlock;
import teamroots.embers.block.IModeledBlock;
import teamroots.embers.compat.BaublesIntegration;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.compat.Util;
import teamroots.embers.compat.environmentaltech.EnvironmentalTechIntegration;
import teamroots.embers.compat.thaumcraft.ThaumcraftIntegration;
import teamroots.embers.compat.thaumicaugmentation.ThaumicAugmentationIntegration;
import teamroots.embers.compat.thaumicperiphery.ThaumicPeripheryIntegration;
import teamroots.embers.config.ConfigMob;
import teamroots.embers.entity.EntityAncientGolem;
import teamroots.embers.item.IModeledItem;
import teamroots.embers.item.ItemEmberStorage;
import teamroots.embers.item.ItemTyrfing;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityStorage;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.register.EntityRegister;
import teamroots.embers.register.EntityRenderingHandlerRegister;
import teamroots.embers.register.FluidRegister;
import teamroots.embers.register.ItemModifierRegister;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.register.TileEntityRegister;
import teamroots.embers.register.TileEntitySpecialRendererRegister;
import teamroots.embers.research.capability.DefaultResearchCapability;
import teamroots.embers.research.capability.IResearchCapability;
import teamroots.embers.tileentity.TileEntityBeamCannon;
import teamroots.embers.upgrade.UpgradeCatalyticPlug;
import teamroots.embers.util.DefaultUpgradeProvider;
import teamroots.embers.util.EmbersFuelHandler;
import teamroots.embers.util.ExtraSerializers;
import teamroots.embers.world.WorldGenOres;
import teamroots.embers.world.WorldGenSmallRuin;
import thaumcraft.api.casters.ICaster;
import thaumcraft.common.items.casters.ItemFocus;
import thecodex6824.thaumicaugmentation.api.item.IDyeableItem;

public class RegistryManager {
    public static WorldGenOres world_gen_ores;
    public static IWorldGenerator world_gen_small_ruin;

    public static void registerAll() {
        RegistryManager.registerCapabilities();
        FluidRegister.INSTANCE.register();
        EntityRegister.INSTANCE.register();
        ItemModifierRegister.INSTANCE.register();
        TileEntityRegister.INSTANCE.register();
        ArrayList biomeEntries = new ArrayList();
        biomeEntries.addAll(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL));
        biomeEntries.addAll(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT));
        biomeEntries.addAll(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY));
        biomeEntries.addAll(BiomeManager.getBiomes((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM));
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (BiomeManager.BiomeEntry b : biomeEntries) {
            biomes.add(b.biome);
        }
        biomes.addAll(BiomeManager.oceanBiomes);
        if (ConfigMob.EMBER_GOLEM.enableSpawning) {
            EntityRegistry.addSpawn(EntityAncientGolem.class, (int)ConfigMob.EMBER_GOLEM.spawnWeight, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes.toArray(new Biome[biomes.size()]));
        }
        world_gen_ores = new WorldGenOres();
        GameRegistry.registerWorldGenerator((IWorldGenerator)world_gen_ores, (int)1);
        world_gen_small_ruin = new WorldGenSmallRuin();
        GameRegistry.registerWorldGenerator((IWorldGenerator)world_gen_small_ruin, (int)400);
        MinecraftForge.EVENT_BUS.register(EmbersFuelHandler.class);
        UpgradeCatalyticPlug.registerBlacklistedTile(TileEntityBeamCannon.class);
        if (Util.isBaublesIntegrationEnabled()) {
            BaublesIntegration.registerAll();
        }
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.registerAll();
        }
        if (Util.isEnvironmentalTechIntegrationEnabled()) {
            EnvironmentalTechIntegration.registerAll();
        }
        if (Util.isThaumcraftIntegrationEnabled()) {
            ThaumcraftIntegration.registerAll();
        }
        if (Util.isThaumicPeripheryIntegrationEnabled()) {
            ThaumicPeripheryIntegration.registerAll();
        }
        if (Util.isThaumicAugmentationIntegrationEnabled()) {
            ThaumicAugmentationIntegration.registerAll();
        }
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IEmberCapability.class, (Capability.IStorage)new EmberCapabilityStorage(), DefaultEmberCapability.class);
        CapabilityManager.INSTANCE.register(IUpgradeProvider.class, (Capability.IStorage)new Capability.IStorage<IUpgradeProvider>(){

            @Nullable
            public NBTBase writeNBT(Capability<IUpgradeProvider> capability, IUpgradeProvider instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IUpgradeProvider> capability, IUpgradeProvider instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new DefaultUpgradeProvider("none", null));
        CapabilityManager.INSTANCE.register(IResearchCapability.class, (Capability.IStorage)new Capability.IStorage<IResearchCapability>(){

            @Nullable
            public NBTBase writeNBT(Capability<IResearchCapability> capability, IResearchCapability instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                instance.writeToNBT(compound);
                return compound;
            }

            public void readNBT(Capability<IResearchCapability> capability, IResearchCapability instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                instance.readFromNBT(compound);
            }
        }, DefaultResearchCapability::new);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block b : BlockRegister.INSTANCE.load()) {
            event.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item i : ItemRegister.INSTANCE.load()) {
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
        for (Block b : BlockRegister.INSTANCE.load()) {
            Item itemBlock;
            if (!(b instanceof IBlock) || (itemBlock = ((IBlock)b).getItemBlock()) == null) continue;
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColorHandlers() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemEmberStorage.ColorHandler(), new Item[]{ItemRegister.EMBER_JAR});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemEmberStorage.ColorHandler(), new Item[]{ItemRegister.EMBER_CARTRIDGE});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemTyrfing.ColorHandler(), new Item[]{ItemRegister.TYRFING});
        if (Util.isThaumicAugmentationIntegrationEnabled() && Util.isThaumicPeripheryIntegrationEnabled()) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
                if (tintIndex == 1 && stack.func_77973_b() instanceof ICaster && ((ICaster)stack.func_77973_b()).getFocus(stack) != null) {
                    return ((ItemFocus)((ICaster)stack.func_77973_b()).getFocus(stack)).getFocusColor(((ICaster)stack.func_77973_b()).getFocusStack(stack));
                }
                return tintIndex == 2 && stack.func_77973_b() instanceof IDyeableItem ? ((IDyeableItem)stack.func_77973_b()).getDyedColor(stack) : -1;
            }, new Item[]{ThaumicAugmentationIntegration.TIERED_EMBER_CASTER});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerEntityRendering() {
        TileEntitySpecialRendererRegister.INSTANCE.register();
        EntityRenderingHandlerRegister.INSTANCE.register();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerRendering(ModelRegistryEvent event) {
        for (Block block : BlockRegister.INSTANCE.load()) {
            if (!(block instanceof IModeledBlock)) continue;
            ((IModeledBlock)block).initModel();
        }
        for (Item item : ItemRegister.INSTANCE.load()) {
            if (!(item instanceof IModeledItem)) continue;
            ((IModeledItem)item).initModel();
        }
        if (Util.isThaumicPeripheryIntegrationEnabled()) {
            ModelLoader.setCustomModelResourceLocation((Item)ThaumicPeripheryIntegration.EMBER_CASTER, (int)0, (ModelResourceLocation)new ModelResourceLocation("thaumicperiphery:caster_ember"));
            if (Util.isThaumicAugmentationIntegrationEnabled()) {
                ModelLoader.setCustomModelResourceLocation((Item)ThaumicAugmentationIntegration.TIERED_EMBER_CASTER, (int)0, (ModelResourceLocation)new ModelResourceLocation("embers:gauntlet_thaumium"));
                ModelLoader.setCustomModelResourceLocation((Item)ThaumicAugmentationIntegration.TIERED_EMBER_CASTER, (int)1, (ModelResourceLocation)new ModelResourceLocation("embers:gauntlet_void"));
            }
        }
    }

    @SubscribeEvent
    public void init(RegistryEvent.Register<DataSerializerEntry> event) {
        event.getRegistry().register(new DataSerializerEntry(ExtraSerializers.FLOAT_ARRAY).setRegistryName("embers", "serializer_float_array"));
    }

    public static class tupleERH {
        protected final Class<? extends Entity> entityClass;
        protected final Render<? extends Entity> renderer;

        public tupleERH(Class<? extends Entity> entityClass, Render<? extends Entity> renderer) {
            this.entityClass = entityClass;
            this.renderer = renderer;
        }
    }

    public static class tupleTESR {
        protected final Class<? extends TileEntity> tileEntityClass;
        protected final TileEntitySpecialRenderer<? super TileEntity> specialRenderer;

        public tupleTESR(Class<? extends TileEntity> tileEntityClass, TileEntitySpecialRenderer<? super TileEntity> specialRenderer) {
            this.tileEntityClass = tileEntityClass;
            this.specialRenderer = specialRenderer;
        }
    }

    public static class tupleTileEntity {
        protected final Class<? extends TileEntity> te_class;
        protected final ResourceLocation location;

        public tupleTileEntity(Class<? extends TileEntity> te_class, String name) {
            this.te_class = te_class;
            this.location = new ResourceLocation("embers", name);
        }
    }
}

