/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.power;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;

public class DefaultEmberItemCapability
implements ICapabilityProvider,
IEmberCapability {
    @Nonnull
    private ItemStack stack;

    public DefaultEmberItemCapability(@Nonnull ItemStack stack, double capacity) {
        this.stack = stack;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            this.setEmber(0.0);
            this.setEmberCapacity(capacity);
        } else {
            this.migrateLegacy();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == EmbersCapabilities.EMBER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)EmbersCapabilities.EMBER_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public double getEmber() {
        return this.stack.func_77942_o() ? this.stack.func_77978_p().func_74769_h("ember") : 0.0;
    }

    @Override
    public double getEmberCapacity() {
        return this.stack.func_77942_o() ? this.stack.func_77978_p().func_74769_h("emberCapacity") : 0.0;
    }

    @Override
    public void setEmber(double value) {
        if (this.stack.func_77942_o()) {
            this.stack.func_77978_p().func_74780_a("ember", value);
        }
    }

    @Override
    public void setEmberCapacity(double value) {
        if (this.stack.func_77942_o()) {
            this.stack.func_77978_p().func_74780_a("emberCapacity", value);
        }
    }

    @Override
    public double addAmount(double value, boolean doAdd) {
        double ember = this.getEmber();
        double capacity = this.getEmberCapacity();
        double added = Math.min(capacity - ember, value);
        double newEmber = ember + added;
        if (doAdd) {
            if (newEmber != ember) {
                this.onContentsChanged();
            }
            this.setEmber(ember + added);
        }
        return added;
    }

    @Override
    public double removeAmount(double value, boolean doRemove) {
        double ember = this.getEmber();
        double removed = Math.min(ember, value);
        double newEmber = ember - removed;
        if (doRemove) {
            if (newEmber != ember) {
                this.onContentsChanged();
            }
            this.setEmber(ember - removed);
        }
        return removed;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void onContentsChanged() {
    }

    public void migrateLegacy() {
        if (this.stack.func_77942_o()) {
            NBTTagCompound compound = this.stack.func_77978_p();
            if (compound.func_74764_b("embers:ember")) {
                compound.func_74780_a("ember", compound.func_74769_h("embers:ember"));
                compound.func_82580_o("embers:ember");
            }
            if (compound.func_74764_b("embers:emberCapacity")) {
                compound.func_74780_a("emberCapacity", compound.func_74769_h("embers:emberCapacity"));
                compound.func_82580_o("embers:emberCapacity");
            }
        }
    }
}

