/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageSuperheatFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ModifierSuperheater
extends ModifierBase {
    public ModifierSuperheater() {
        super(ModifierBase.EnumType.TOOL, "superheater", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack s;
        if (event.getHarvester() instanceof EntityPlayer && !event.getHarvester().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && ItemModUtil.hasHeat(s = event.getHarvester().func_184586_b(EnumHand.MAIN_HAND)) && ItemModUtil.getModifierLevel(s, EmbersAPI.SUPERHEATER) > 0 && EmberInventoryUtil.getEmberTotal(event.getHarvester()) >= this.cost) {
            if (!event.getWorld().field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSuperheatFX((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5));
            }
            event.getWorld().func_184133_a(null, event.getPos(), SoundManager.FIREBALL_HIT, SoundCategory.PLAYERS, 0.5f, event.getWorld().field_73012_v.nextFloat() * 0.5f + 0.2f);
            EmberInventoryUtil.removeEmber(event.getHarvester(), this.cost);
            List stacks = event.getDrops();
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)stacks.get(i)).func_77946_l();
                if (stack.func_190926_b()) continue;
                stacks.add(stack);
                stacks.set(i, ItemStack.field_190927_a);
            }
        }
    }

    private double getBurnBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 0.5;
        }
        return resonance;
    }

    private double getDamageBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 1.0;
        }
        return resonance;
    }

    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        int level;
        EntityPlayer damager;
        ItemStack s;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(s = (damager = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && ItemModUtil.hasHeat(s) && (level = ItemModUtil.getModifierLevel(s, EmbersAPI.SUPERHEATER)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
            double resonance = EmbersAPI.getEmberEfficiency(s);
            int burnTime = (int)(Math.pow(2.0, level - 1) * 5.0 * this.getBurnBonus(resonance));
            float extraDamage = (float)((double)level * this.getDamageBonus(resonance));
            event.getEntityLiving().func_70015_d(burnTime);
            if (!damager.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSuperheatFX(event.getEntity().field_70165_t, event.getEntity().field_70163_u + (double)event.getEntity().field_70131_O / 2.0, event.getEntity().field_70161_v));
            }
            EmberInventoryUtil.removeEmber(damager, this.cost);
            event.setAmount(event.getAmount() + extraDamage);
        }
    }
}

