/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.tileentity.TileEntityTank;

public class ItemBlockTank
extends ItemBlock {
    public ItemBlockTank(Block block) {
        super(block);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, TileEntityTank.capacity){

            protected void setFluid(FluidStack fluid) {
                if (!this.container.func_77942_o()) {
                    this.container.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound tagCompound = this.container.func_77978_p();
                tagCompound.func_82580_o("Empty");
                fluid.writeToNBT(tagCompound);
            }

            @Nullable
            public FluidStack getFluid() {
                NBTTagCompound tagCompound = this.container.func_77978_p();
                if (tagCompound == null || tagCompound.func_74764_b("Empty")) {
                    return null;
                }
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
            }

            protected void setContainerToEmpty() {
                NBTTagCompound tagCompound = this.container.func_77978_p();
                tagCompound.func_74778_a("Empty", "");
                tagCompound.func_82580_o("FluidName");
                tagCompound.func_82580_o("Amount");
                tagCompound.func_82580_o("Tag");
            }
        };
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandler handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            for (IFluidTankProperties properties : handler.getTankProperties()) {
                FluidStack fluidStack = properties.getContents();
                tooltip.add(TextFormatting.GRAY + BlockFluidGauge.formatFluidStack(fluidStack, properties.getCapacity()));
            }
        }
    }
}

