/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.heat;

import net.minecraft.nbt.NBTTagCompound;
import teamroots.embers.heat.IHeatCapability;

public class DefaultHeatCapability
implements IHeatCapability {
    private double heat = 0.0;
    private double capacity = 0.0;

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public double getHeatCapacity() {
        return this.capacity;
    }

    @Override
    public void setHeat(double value) {
        this.heat = value;
    }

    @Override
    public void setHeatCapacity(double value) {
        this.capacity = value;
    }

    @Override
    public double addAmount(double value, boolean doAdd) {
        if (this.heat + value > this.capacity) {
            double added = this.capacity - this.heat;
            if (doAdd) {
                this.heat = this.capacity;
            }
            return added;
        }
        if (doAdd) {
            this.heat += value;
        }
        return value;
    }

    @Override
    public double removeAmount(double value, boolean doRemove) {
        if (this.heat - value < 0.0) {
            double removed = this.heat;
            if (doRemove) {
                this.heat = 0.0;
            }
            return removed;
        }
        if (doRemove) {
            this.heat -= value;
        }
        return value;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("embers:heat", this.heat);
        tag.func_74780_a("embers:heatCapacity", this.capacity);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("embers:heat")) {
            this.heat = tag.func_74769_h("embers:heat");
        }
        if (tag.func_74764_b("embers:heatCapacity")) {
            this.capacity = tag.func_74769_h("embers:heatCapacity");
        }
    }
}

