/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.util.Bezier;

public class Lunge
extends MagmaWormPhase {
    private static final double RANGE_ATTACK = 36.0;
    private int digCooldown;
    private int undigCooldown;
    private Entity entity;
    private int repeat;
    private double velocity = 0.25;

    public Lunge(MagmaWormPhase.PhaseSupplier supplier, int repeat) {
        super(supplier);
        this.repeat = repeat;
    }

    public Lunge(MagmaWormPhase.PhaseSupplier supplier, Entity entity, int repeat) {
        super(supplier);
        this.entity = entity;
        this.repeat = repeat;
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        if (worm.isDigging()) {
            return 0.5;
        }
        return this.velocity;
    }

    @Override
    public MagmaWormPhase pickFollowup(Random random) {
        if (this.repeat > 0) {
            return new Lunge(this.supplier, this.entity, this.repeat - 1);
        }
        return super.pickFollowup(random);
    }

    @Override
    public void onStart(EntityMagmaWorm worm) {
        List<Entity> targets = worm.getAttackTargets(new AxisAlignedBB(worm.field_70165_t - 36.0, worm.field_70163_u - 36.0, worm.field_70161_v - 36.0, worm.field_70165_t + 36.0, worm.field_70163_u + 36.0, worm.field_70161_v + 36.0));
        if (!targets.isEmpty()) {
            Entity target = targets.get(this.random.nextInt(targets.size()));
            ArrayList<Vec3d> points = new ArrayList<Vec3d>();
            points.add(new Vec3d(worm.field_70165_t, worm.field_70163_u, worm.field_70161_v));
            points.add(new Vec3d(worm.field_70165_t, MagmaWormPhase.getHeight(worm.field_70170_p, worm.field_70165_t, worm.field_70161_v) + 3.0, worm.field_70161_v));
            Vec3d targetPos = new Vec3d(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
            points.add(targetPos);
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double dx = Math.sin(angle) * 10.0;
            double dz = Math.cos(angle) * 10.0;
            double height = MagmaWormPhase.getHeight(worm.field_70170_p, targetPos.field_72450_a + dx, targetPos.field_72449_c + dz);
            points.add(new Vec3d(targetPos.field_72450_a + dx, height - 5.0, targetPos.field_72449_c + dz));
            worm.setCurrentSpline(new Bezier(points), 10, 0.3);
        }
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        --this.digCooldown;
        --this.undigCooldown;
        this.velocity = Math.min(2.0, this.velocity + 0.01);
    }

    @Override
    public void onDig(EntityMagmaWorm worm) {
        if (this.digCooldown > 0) {
            return;
        }
        Vec3d location = new Vec3d(worm.field_70165_t, worm.field_70163_u + 2.0, worm.field_70161_v);
        Lunge.splashMagma(worm, location, 6);
        this.digCooldown = 30;
    }

    @Override
    public void onUndig(EntityMagmaWorm worm) {
        if (this.undigCooldown > 0) {
            return;
        }
        Vec3d location = new Vec3d(worm.field_70165_t, worm.field_70163_u + 2.0, worm.field_70161_v);
        Lunge.splashMagma(worm, location, 6);
        this.undigCooldown = 30;
    }
}

