/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.config;

import java.util.Arrays;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Loader;

@Config(modid="embers", category="material", name="Embers/material")
@Config.LangKey(value="cfg.embers.material")
public class ConfigMaterial {
    @Config.Name(value="Copper")
    @Config.LangKey(value="cfg.embers.material.copper")
    @Config.Comment(value={"Options for Copper"})
    public static final Material COPPER = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Silver")
    @Config.LangKey(value="cfg.embers.material.silver")
    @Config.Comment(value={"Options for Silver"})
    public static final Material SILVER = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Lead")
    @Config.LangKey(value="cfg.embers.material.lead")
    @Config.Comment(value={"Options for Lead"})
    public static final Material LEAD = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Aluminum")
    @Config.LangKey(value="cfg.embers.material.aluminum")
    @Config.Comment(value={"Options for Aluminum"})
    public static final Material ALUMINUM = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Bronze")
    @Config.LangKey(value="cfg.embers.material.bronze")
    @Config.Comment(value={"Options for Bronze"})
    public static final Material BRONZE = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation"});
    @Config.Name(value="Electrum")
    @Config.LangKey(value="cfg.embers.material.electrum")
    @Config.Comment(value={"Options for Electrum"})
    public static final Material ELECTRUM = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Nickel")
    @Config.LangKey(value="cfg.embers.material.nickel")
    @Config.Comment(value={"Options for Nickel"})
    public static final Material NICKEL = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Tin")
    @Config.LangKey(value="cfg.embers.material.tin")
    @Config.Comment(value={"Options for Tin"})
    public static final Material TIN = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation"});
    @Config.Name(value="Iron")
    @Config.LangKey(value="cfg.embers.material.iron")
    @Config.Comment(value={"Options for Iron"})
    public static final Material IRON = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Gold")
    @Config.LangKey(value="cfg.embers.material.gold")
    @Config.Comment(value={"Options for Gold"})
    public static final Material GOLD = new Material(RegistrationModes.SMART, new String[]{"thermalfoundation", "immersiveengineering"});
    @Config.Name(value="Dawnstone")
    @Config.LangKey(value="cfg.embers.material.dawnstone")
    @Config.Comment(value={"Options for Dawnstone"})
    public static final Material DAWNSTONE = new Material(RegistrationModes.SMART, new String[0]);
    @Config.Name(value="Mithril")
    @Config.LangKey(value="cfg.embers.material.mithril")
    @Config.Comment(value={"[WIP] Options for Mithril"})
    public static final Material MITHRIL = new Material(RegistrationModes.OFF, new String[0]);
    @Config.Name(value="Astralite")
    @Config.LangKey(value="cfg.embers.material.astralite")
    @Config.Comment(value={"[WIP] Options for Astralite"})
    public static final Material ASTRALITE = new Material(RegistrationModes.OFF, new String[0]);
    @Config.Name(value="Umber Steel")
    @Config.LangKey(value="cfg.embers.material.umber_steel")
    @Config.Comment(value={"[WIP] Options for Umber Steel"})
    public static final Material UMBERSTEEL = new Material(RegistrationModes.OFF, new String[0]);

    public static class Material {
        @Config.RequiresMcRestart
        @Config.Name(value="Registration Mode")
        @Config.Comment(value={"FORCE - Register the material independent of other mods", "OFF - Don't register the material at all", "SMART - Don't register the material if it already exists", "SEED - Only register the seed for the material"})
        public RegistrationModes registrationMode;
        @Config.RequiresMcRestart
        @Config.Name(value="*SMART* Mods")
        @Config.Comment(value={"A list of all mods, that will be used in the SMART registration check.", "If a mod in this list is loaded, the material will not be registered."})
        public String[] smartMods;

        public boolean isNotOff() {
            return this.registrationMode != RegistrationModes.OFF;
        }

        public boolean mustLoad() {
            return this.isNotOff() && (this.registrationMode == RegistrationModes.FORCE || Arrays.stream(this.smartMods).noneMatch(Loader::isModLoaded));
        }

        public boolean registerSeed() {
            return this.registrationMode == RegistrationModes.SEED || this.isNotOff();
        }

        private Material(RegistrationModes registrationMode, String[] smartMods) {
            this.registrationMode = registrationMode;
            this.smartMods = smartMods;
        }
    }

    public static enum RegistrationModes {
        FORCE,
        OFF,
        SMART,
        SEED;

    }
}

