/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.Comp;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.Property;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderMethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import com.google.common.collect.Lists;
import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.compat.groovyscript.GSPlugin;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.util.AlchemyUtil;

@RegistryDescription(linkGenerator="embers")
public class Alchemy
extends VirtualizedRegistry<AlchemyRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".input(item('minecraft:clay'),item('minecraft:clay'),item('minecraft:clay'),item('minecraft:clay')).output(item('minecraft:gravel')).setAspect('dawnstone', 2, 17).setAspect('glass', 1, 8)"), @Example(value=".input(item('minecraft:gravel'),ore('dyeGreen'),ore('dyeGreen'),ore('dyeGreen'),item('minecraft:rotten_flesh')).output(item('minecraft:grass')).setAspect('iron', 2, 17).setAspect('copper', 1, 8)")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        RecipeRegistry.alchemyRecipes.removeAll(this.removeScripted());
        RecipeRegistry.alchemyRecipes.addAll(this.restoreFromBackup());
    }

    public void add(AlchemyRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            RecipeRegistry.alchemyRecipes.add(recipe);
        }
    }

    public boolean remove(AlchemyRecipe recipe) {
        if (RecipeRegistry.alchemyRecipes.removeIf(r -> r == recipe)) {
            this.addBackup(recipe);
            return true;
        }
        return false;
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, description="groovyscript.wiki.embers.alchemy.removebycenter", example={@Example(value="item('minecraft:wool')")})
    public boolean removeByCenter(IIngredient input) {
        return RecipeRegistry.alchemyRecipes.removeIf(r -> {
            if (Arrays.stream(r.getCenter().func_193365_a()).anyMatch((Predicate<ItemStack>)input)) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="item('embers:ember_pipe')")})
    public boolean removeByOutput(IIngredient output) {
        return RecipeRegistry.alchemyRecipes.removeIf(r -> {
            if (output.test((Object)r.getOutput())) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, description="groovyscript.wiki.embers.alchemy.removeaspect", example={@Example(value="'copper'")})
    public boolean removeAspect(String aspect) {
        if (!AlchemyUtil.hasAspect(aspect)) {
            return false;
        }
        AlchemyUtil.removeAspect(aspect);
        return true;
    }

    @MethodDescription(type=MethodDescription.Type.ADDITION, description="groovyscript.wiki.embers.alchemy.addaspect", example={@Example(value="'copper',item('minecraft:gold_ingot')"), @Example(value="'glass',item('minecraft:glass')")})
    public boolean addAspect(String aspect, IIngredient item) {
        if (this.getAspect(item) != null) {
            return false;
        }
        AlchemyUtil.registerAspect(aspect, item.toMcIngredient());
        return true;
    }

    @MethodDescription(type=MethodDescription.Type.VALUE, description="groovyscript.wiki.embers.alchemy.getaspect", example={@Example(value="item('embers:aspectus_iron')")})
    public String getAspect(IIngredient item) {
        return AlchemyUtil.getAspect(IngredientHelper.toItemStack((IIngredient)item));
    }

    @MethodDescription(type=MethodDescription.Type.QUERY)
    public SimpleObjectStream<AlchemyRecipe> streamRecipes() {
        return new SimpleObjectStream(RecipeRegistry.alchemyRecipes).setRemover(this::remove);
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, priority=2000, example={@Example(commented=true)})
    public void removeAll() {
        RecipeRegistry.alchemyRecipes.forEach(arg_0 -> ((Alchemy)this).addBackup(arg_0));
        RecipeRegistry.alchemyRecipes.clear();
    }

    @Property.Properties(value={@Property(property="input", valid={@Comp(value="1", type=Comp.Type.GTE), @Comp(value="5", type=Comp.Type.LTE)}), @Property(property="output", valid={@Comp(value="1")})})
    public static class RecipeBuilder
    extends AbstractRecipeBuilder<AlchemyRecipe> {
        @Property(valid={@Comp(value="empty", type=Comp.Type.NOT)})
        private final AspectList.AspectRangeList aspects = new AspectList.AspectRangeList();

        @RecipeBuilderMethodDescription(field={"aspects"})
        public RecipeBuilder setAspect(String aspect, int min, int max) {
            this.aspects.setRange(aspect, min, max);
            return this;
        }

        public String getErrorMsg() {
            return "Error adding Embers Alchemy recipe";
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 5, 1, 1);
            this.validateFluids(msg);
            msg.add(this.aspects.isEmpty(), "Aspects are required!", new Object[0]);
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public AlchemyRecipe register() {
            if (!this.validate()) {
                return null;
            }
            ArrayList outerIngredients = Lists.newArrayList();
            for (int i = 1; i < this.input.size(); ++i) {
                outerIngredients.add(((IIngredient)this.input.get(i)).toMcIngredient());
            }
            AlchemyRecipe recipe = new AlchemyRecipe(this.aspects.fixMathematicalError(), ((IIngredient)this.input.get(0)).toMcIngredient(), outerIngredients, (ItemStack)this.output.get(0));
            GSPlugin.instance.alchemy.add(recipe);
            return recipe;
        }
    }
}

