/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.util.Misc;

public class StructureBase {
    public boolean replaceWithAir = false;
    public ArrayList<String[]> layers = new ArrayList();
    public int width = 0;
    public int length = 0;
    public Map<String, IBlockState> blocks = new HashMap<String, IBlockState>();

    public StructureBase(int w, int h) {
        this.width = w;
        this.length = h;
    }

    public StructureBase addLayer(String[] layer) {
        this.layers.add(layer);
        return this;
    }

    public void generateIn(World world, int x, int y, int z, boolean randomRotation) {
        int angle = 0;
        if (randomRotation) {
            angle = 90 * Misc.random.nextInt(4);
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            for (int j = 0; j < this.layers.get(i).length; ++j) {
                for (int k = 0; k < this.layers.get(i)[j].length(); ++k) {
                    if (angle == 0) {
                        this.placeBlock(world, new BlockPos(x + j - this.width / 2, y + i, z + k - this.length / 2), this.blocks.get(this.layers.get(i)[j].substring(k, k + 1)));
                    }
                    if (angle == 90) {
                        this.placeBlock(world, new BlockPos(x + k - this.length / 2, y + i, z + j - this.width / 2), this.blocks.get(this.layers.get(i)[j].substring(k, k + 1)));
                    }
                    if (angle == 180) {
                        this.placeBlock(world, new BlockPos(x - j + this.width / 2, y + i, z - k + this.length / 2), this.blocks.get(this.layers.get(i)[j].substring(k, k + 1)));
                    }
                    if (angle != 270) continue;
                    this.placeBlock(world, new BlockPos(x - k + this.length / 2, y + i, z - j + this.width / 2), this.blocks.get(this.layers.get(i)[j].substring(k, k + 1)));
                }
            }
        }
    }

    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        if (state.getBlock() != Blocks.AIR || state.getBlock() == Blocks.AIR && this.replaceWithAir) {
            world.setBlockState(pos, state);
        }
    }

    public StructureBase addBlockMapping(String name, IBlockState state) {
        this.blocks.put(name, state);
        return this;
    }
}

