/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.embers.SoundManager;
import teamroots.embers.config.ConfigWorld;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageMetallurgicDustFX;

public class OreTransmutationUtil {
    public static final int ITERATIONS_PER_TICK = ConfigWorld.TRANSMUTATION.iterations_per_tick;
    public static final int MAX_BLOCKS = ConfigWorld.TRANSMUTATION.max_blocks;
    public static final String STONE = "stone";
    public static final String NETHER = "nether";
    public static final String END = "end";
    public static final String SAND = "sand";
    public static final String BETWEEN_STONE = "betweenlands";
    public static final String BETWEEN_PIT = "betweenlands_pit";
    public static final String BETWEEN_GEM = "betweenlands_gem";
    public static final HashMap<String, String> ALTERNATE_ORES = new HashMap();
    public static final double FAIL_CHANCE = ConfigWorld.TRANSMUTATION.fail_chance;
    static LinkedHashMap<String, TransmutationSet> REGISTRY = new LinkedHashMap();
    static ArrayList<TransmutationIterator> iterators = new ArrayList();
    static int iteratorIndex;
    static Random random;

    public static void init() {
        OreTransmutationUtil.registerTransmutationSet(STONE, Blocks.STONE.getDefaultState());
        OreTransmutationUtil.registerTransmutationSet(NETHER, Blocks.NETHERRACK.getDefaultState());
        OreTransmutationUtil.registerTransmutationSet(END, Blocks.END_STONE.getDefaultState());
        OreTransmutationUtil.registerTransmutationSet(SAND, Blocks.SAND.getDefaultState());
        OreTransmutationUtil.registerTransmutationSet(BETWEEN_STONE, new ResourceLocation("thebetweenlands:betweenstone"), 0);
        OreTransmutationUtil.registerTransmutationSet(BETWEEN_PIT, new ResourceLocation("thebetweenlands:pitstone"), 0);
        OreTransmutationUtil.registerTransmutationSet(BETWEEN_GEM, new ResourceLocation("thebetweenlands:mud"), 0);
        OreTransmutationUtil.registerOre(STONE, Blocks.LIT_REDSTONE_ORE.getDefaultState());
        OreTransmutationUtil.registerOre(BETWEEN_PIT, new ResourceLocation("betweenores:lit_redstone_ore"), 0);
        ALTERNATE_ORES.put("minecraft:quartz_ore", NETHER);
        ALTERNATE_ORES.put("tconstruct:ore", NETHER);
        ALTERNATE_ORES.put("astralsorcery:blockcustomsandore", SAND);
        ALTERNATE_ORES.put("thebetweenlands:slimy_bone_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("thebetweenlands:sulfur_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("thebetweenlands:syrmorite_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("thebetweenlands:octine_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("thebetweenlands:valonite_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("thebetweenlands:scabyst_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("thebetweenlands:aqua_middle_gem_ore", BETWEEN_GEM);
        ALTERNATE_ORES.put("thebetweenlands:crimson_middle_gem_ore", BETWEEN_GEM);
        ALTERNATE_ORES.put("thebetweenlands:green_middle_gem_ore", BETWEEN_GEM);
        ALTERNATE_ORES.put("betweenores:iron_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("betweenores:copper_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("betweenores:tin_ore", BETWEEN_STONE);
        ALTERNATE_ORES.put("betweenores:gold_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:redstone_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:lapis_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:diamond_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:lead_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:nickel_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:silver_ore", BETWEEN_PIT);
        ALTERNATE_ORES.put("betweenores:quartz_ore", BETWEEN_PIT);
        OreTransmutationUtil.gatherOreTransmutations();
        MinecraftForge.EVENT_BUS.register(OreTransmutationUtil.class);
    }

    public static void gatherOreTransmutations() {
        HashSet<String> existingTags = new HashSet<String>();
        for (String orename : OreDictionary.getOreNames()) {
            if (orename == null || !orename.startsWith("ore")) continue;
            for (ItemStack stack : OreDictionary.getOres((String)orename, (boolean)false)) {
                String entry;
                String tag;
                ResourceLocation registryName;
                Item item = stack.getItem();
                if (!(item instanceof ItemBlock) || (registryName = item.getRegistryName()) == null || existingTags.contains(tag = (entry = ALTERNATE_ORES.getOrDefault(registryName.toString(), STONE)) + ":" + orename)) continue;
                if (!ForgeRegistries.BLOCKS.containsKey(registryName)) {
                    return;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
                IBlockState defaultState = block.getDefaultState();
                if (!defaultState.isFullCube()) continue;
                if (stack.getMetadata() == Short.MAX_VALUE) {
                    OreTransmutationUtil.registerOre(entry, block);
                } else {
                    OreTransmutationUtil.registerOre(entry, block.getStateFromMeta(stack.getMetadata()));
                }
                existingTags.add(tag);
            }
        }
    }

    public static void registerTransmutationSet(String name, IBlockState failure) {
        REGISTRY.put(name, new TransmutationSet(name, failure));
    }

    public static void registerTransmutationSet(String name, ResourceLocation failure, int meta) {
        if (!ForgeRegistries.BLOCKS.containsKey(failure)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(failure);
        OreTransmutationUtil.registerTransmutationSet(name, block.getStateFromMeta(meta));
    }

    public static void registerOre(String name, IBlockState ore) {
        TransmutationSet set = REGISTRY.get(name);
        if (set != null) {
            set.ores.add(ore);
        }
    }

    public static void registerOre(String name, Block ore) {
        TransmutationSet set = REGISTRY.get(name);
        if (set != null) {
            NonNullList stacks = NonNullList.create();
            ore.getSubBlocks(CreativeTabs.SEARCH, stacks);
            for (ItemStack stack : stacks) {
                set.ores.add(ore.getStateFromMeta(stack.getMetadata()));
            }
        }
    }

    public static void registerOre(String name, ResourceLocation ore, int meta) {
        if (!ForgeRegistries.BLOCKS.containsKey(ore)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ore);
        OreTransmutationUtil.registerOre(name, block.getStateFromMeta(meta));
    }

    public static void registerOre(String name, ResourceLocation ore) {
        if (!ForgeRegistries.BLOCKS.containsKey(ore)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(ore);
        OreTransmutationUtil.registerOre(name, block);
    }

    public static TransmutationSet getFromOre(IBlockState state) {
        for (TransmutationSet entry : REGISTRY.values()) {
            if (!entry.ores.contains(state)) continue;
            return entry;
        }
        return null;
    }

    public static boolean transmuteOres(World world, BlockPos pos) {
        return OreTransmutationUtil.transmuteOres(world, pos, MAX_BLOCKS);
    }

    public static boolean transmuteOres(World world, BlockPos pos, int limit) {
        IBlockState fromReplace = world.getBlockState(pos);
        TransmutationSet set = OreTransmutationUtil.getFromOre(fromReplace);
        if (set != null) {
            List replacements = set.ores.stream().filter(ore -> ore != fromReplace).collect(Collectors.toList());
            if (replacements.isEmpty()) {
                return false;
            }
            IBlockState toReplace = (IBlockState)replacements.get(random.nextInt(replacements.size()));
            iterators.add(new TransmutationIterator(world, pos, fromReplace, toReplace, set.failure, limit));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (iterators.isEmpty()) {
            return;
        }
        for (int i = 0; i < ITERATIONS_PER_TICK; ++i) {
            TransmutationIterator iterator = iterators.get(iteratorIndex % iterators.size());
            iterator.iterate();
            ++iteratorIndex;
        }
        iterators.removeIf(TransmutationIterator::isDone);
    }

    static {
        random = new Random();
    }

    public static class TransmutationIterator {
        public Random random = new Random();
        public World world;
        public IBlockState fromReplace;
        public IBlockState toReplace;
        public IBlockState toFailure;
        public HashSet<BlockPos> visitedPositions = new HashSet();
        public ArrayList<BlockPos> toVisit = new ArrayList();
        public int maxBlocks = Integer.MAX_VALUE;

        public TransmutationIterator(World world, BlockPos start, IBlockState fromReplace, IBlockState toReplace, IBlockState toFailure, int maxBlocks) {
            this.world = world;
            this.fromReplace = fromReplace;
            this.toReplace = toReplace;
            this.toFailure = toFailure;
            this.toVisit.add(start);
            this.maxBlocks = maxBlocks;
        }

        public boolean isDone() {
            return this.toVisit.isEmpty() || this.visitedPositions.size() >= this.maxBlocks;
        }

        public void iterate() {
            if (this.toVisit.isEmpty()) {
                return;
            }
            int index = this.random.nextInt(this.toVisit.size());
            BlockPos visit = this.toVisit.get(index);
            this.toVisit.remove(index);
            IBlockState state = this.world.getBlockState(visit);
            if (state != this.fromReplace) {
                return;
            }
            boolean failed = this.random.nextDouble() < FAIL_CHANCE;
            this.world.setBlockState(visit, failed ? this.toFailure : this.toReplace, 2);
            this.world.playSound(null, visit, failed ? SoundManager.METALLURGIC_DUST_FAIL : SoundManager.METALLURGIC_DUST, SoundCategory.BLOCKS, 1.0f, this.random.nextFloat() + 0.5f);
            if (failed) {
                this.world.playEvent(2001, visit, Block.getStateId((IBlockState)state));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageMetallurgicDustFX(visit.getX(), visit.getY(), visit.getZ()));
            }
            this.visitedPositions.add(visit);
            for (EnumFacing facing : EnumFacing.VALUES) {
                BlockPos neighbor = visit.offset(facing);
                if (this.visitedPositions.contains(neighbor)) continue;
                this.toVisit.add(neighbor);
            }
        }
    }

    public static class TransmutationSet {
        public String name;
        public IBlockState failure;
        public HashSet<IBlockState> ores = new HashSet();

        public TransmutationSet(String name, IBlockState failure) {
            this.name = name;
            this.failure = failure;
        }
    }
}

