/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.embers.config.ConfigMaterial;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.util.NoiseGenUtil;

public class EmberGenUtil {
    public static int offX = 0;
    public static int offZ = 0;
    @Deprecated
    public static Map<Item, Double> emberAmounts = new HashMap<Item, Double>();
    @Deprecated
    public static Map<String, Float> metalCoefficients = new HashMap<String, Float>();
    @Deprecated
    public static Map<Item, Float> fuelCoefficients = new HashMap<Item, Float>();
    @Deprecated
    public static Map<Item, Float> catalysisCoefficients = new HashMap<Item, Float>();

    public static float getEmberDensity(long seed, int x, int z) {
        float emberVelocity = 10.0f;
        return (EmberGenUtil.getEmberStability(seed, x, z) + (float)Math.pow((80.0f * NoiseGenUtil.getOctave(seed, x + (int)((float)offX * emberVelocity), z + (int)((float)offZ * emberVelocity), 112) + 20.0f * NoiseGenUtil.getOctave(seed, x + (int)((float)offX * emberVelocity), z + (int)((float)offZ * emberVelocity), 68) + 6.0f * NoiseGenUtil.getOctave(seed, x + (int)((float)offX * emberVelocity), z + (int)((float)offZ * emberVelocity), 34) + 4.0f * NoiseGenUtil.getOctave(seed, x + (int)((float)offX * emberVelocity), z + (int)((float)offZ * emberVelocity), 21) + 2.0f * NoiseGenUtil.getOctave(seed, x + (int)((float)offX * emberVelocity), z + (int)((float)offZ * emberVelocity), 11) + NoiseGenUtil.getOctave(seed, x + (int)((float)offX * emberVelocity), z + (int)((float)offZ * emberVelocity), 4)) / 93.0f, 1.6f)) * 0.5f;
    }

    public static float getEmberStability(long seed, int x, int z) {
        float v = 1.0f - (float)Math.pow((32.0f * NoiseGenUtil.getOctave(seed, x, z, 120) + 16.0f * NoiseGenUtil.getOctave(seed, x, z, 76) + 6.0f * NoiseGenUtil.getOctave(seed, x, z, 45) + 3.0f * NoiseGenUtil.getOctave(seed, x, z, 21) + NoiseGenUtil.getOctave(seed, x, z, 5)) / 58.0f, 3.0);
        return v;
    }

    @Deprecated
    public static void registerEmberFuelItem(Item item, double ember) {
        emberAmounts.put(item, ember);
    }

    @Deprecated
    public static double getEmberForItem(Item item) {
        if (emberAmounts.containsKey(item)) {
            return emberAmounts.get(item);
        }
        return 0.0;
    }

    @Deprecated
    public static void registerMetalCoefficient(String key, float coeff) {
        metalCoefficients.put(key, Float.valueOf(coeff));
    }

    @Deprecated
    public static float getMetalCoefficient(IBlockState state) {
        int[] ids;
        Block b = state.getBlock();
        ItemStack s = new ItemStack(b);
        if (s.isEmpty()) {
            return 0.0f;
        }
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)s)) {
            String key = OreDictionary.getOreName((int)i);
            if (!metalCoefficients.containsKey(key)) continue;
            return metalCoefficients.get(key).floatValue();
        }
        return 0.0f;
    }

    @Deprecated
    public static void registerFuelCoefficient(Item item, float coeff) {
        fuelCoefficients.put(item, Float.valueOf(coeff));
    }

    @Deprecated
    public static float getFuelCoefficient(Item item) {
        if (fuelCoefficients.containsKey(item)) {
            return fuelCoefficients.get(item).floatValue();
        }
        return 0.0f;
    }

    @Deprecated
    public static void registerCatalysisCoefficient(Item item, float coeff) {
        catalysisCoefficients.put(item, Float.valueOf(coeff));
    }

    @Deprecated
    public static float getCatalysisCoefficient(Item item) {
        if (catalysisCoefficients.containsKey(item)) {
            return catalysisCoefficients.get(item).floatValue();
        }
        return 0.0f;
    }

    @Deprecated
    public static void init() {
        EmberGenUtil.registerEmberFuelItem(ItemRegister.SHARD_EMBER, 400.0);
        EmberGenUtil.registerEmberFuelItem(ItemRegister.CRYSTAL_EMBER, 2400.0);
        EmberGenUtil.registerEmberFuelItem(ItemRegister.EMBER_CLUSTER, 3600.0);
        EmberGenUtil.registerMetalCoefficient("blockGold", 1.0f);
        EmberGenUtil.registerMetalCoefficient("blockSilver", 1.0f);
        EmberGenUtil.registerMetalCoefficient("blockCopper", 1.0f);
        if (ConfigMaterial.ELECTRUM.mustLoad()) {
            EmberGenUtil.registerMetalCoefficient("blockElectrum", 1.0f);
        }
        if (ConfigMaterial.ALUMINUM.mustLoad()) {
            EmberGenUtil.registerMetalCoefficient("blockAluminum", 0.9f);
        }
        if (ConfigMaterial.NICKEL.mustLoad()) {
            EmberGenUtil.registerMetalCoefficient("blockNickel", 0.9f);
        }
        if (ConfigMaterial.TIN.mustLoad()) {
            EmberGenUtil.registerMetalCoefficient("blockTin", 0.9f);
        }
        EmberGenUtil.registerMetalCoefficient("blockIron", 0.75f);
        EmberGenUtil.registerMetalCoefficient("blockLead", 0.75f);
        if (ConfigMaterial.BRONZE.mustLoad()) {
            EmberGenUtil.registerMetalCoefficient("blockBronze", 0.75f);
        }
        EmberGenUtil.registerFuelCoefficient(Items.COAL, 2.0f);
        EmberGenUtil.registerFuelCoefficient(Items.NETHERBRICK, 3.0f);
        EmberGenUtil.registerFuelCoefficient(Items.BLAZE_POWDER, 4.0f);
        EmberGenUtil.registerCatalysisCoefficient(Items.REDSTONE, 2.0f);
        EmberGenUtil.registerCatalysisCoefficient(Items.GUNPOWDER, 3.0f);
        EmberGenUtil.registerCatalysisCoefficient(Items.GLOWSTONE_DUST, 4.0f);
    }
}

