/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DecimalFormats
implements IResourceManagerReloadListener {
    private static final Map<String, DecimalFormat> decimalFormats = Maps.newHashMap();

    public static DecimalFormat getDecimalFormat(String key) {
        DecimalFormat format = decimalFormats.get(key);
        if (format == null) {
            format = I18n.hasKey((String)key) ? new DecimalFormat(I18n.format((String)key, (Object[])new Object[0])) : new DecimalFormat("0.#######");
            decimalFormats.put(key, format);
        }
        return format;
    }

    public void onResourceManagerReload(IResourceManager resourceManager) {
        decimalFormats.clear();
    }
}

