/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.ArrayList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.util.AlchemyUtil;
import teamroots.embers.util.IHasAspects;

public class AspectRenderUtil {
    private final IGuiHelper helper;
    private final int aspectbarsX;
    private final int aspectbarsY;
    private final int aspectbars;
    private int u;
    private int v;
    private int width;
    private int height;
    private final int spacing = 4;
    private final ResourceLocation resourceLocation;

    public AspectRenderUtil(IGuiHelper helper, int aspectbars, int aspectbarsX, int aspectbarsY, int u, int v, int width, int height, ResourceLocation resourceLocation) {
        this.helper = helper;
        this.aspectbars = aspectbars;
        this.aspectbarsX = aspectbarsX;
        this.aspectbarsY = aspectbarsY;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.resourceLocation = resourceLocation;
    }

    public void addAspectStacks(IHasAspects hasAspects, IGuiItemStackGroup stacks, int id) {
        ArrayList<String> aspects = new ArrayList<String>(hasAspects.getAspects().getMaxAspects().getAspects());
        for (int i = 0; i < Math.min(aspects.size(), this.aspectbars); ++i) {
            String aspect = aspects.get(i);
            stacks.init(id + i, false, -4, this.aspectbarsY + this.height / 2 - 8 + (this.height + 4) * i);
            stacks.set(id + i, AlchemyUtil.getAspectStacks(aspect));
        }
    }

    public void drawAspectBars(Minecraft minecraft, IHasAspects hasAspects) {
        AspectList.AspectRangeList aspectRange = hasAspects.getAspects();
        ArrayList<String> aspects = new ArrayList<String>(aspectRange.getMaxAspects().getAspects());
        for (int i = 0; i < Math.min(aspects.size(), this.aspectbars); ++i) {
            String aspect = aspects.get(i);
            this.drawAspectBar(minecraft, aspectRange, this.aspectbarsX, this.aspectbarsY + (this.height + 4) * i, aspect);
        }
    }

    public void drawAspectBar(Minecraft minecraft, AspectList.AspectRangeList aspectRange, int x, int y, String aspect) {
        int max = aspectRange.getMax(aspect);
        this.u = 128;
        this.v = 0;
        this.width = 54;
        this.height = 7;
        IDrawableStatic background = this.helper.createDrawable(this.resourceLocation, this.u, this.v + this.height * 2, this.width, this.height);
        background.draw(minecraft, x, y);
        if (max > 0) {
            int min = aspectRange.getMin(aspect);
            int aspectTotal = aspectRange.getMaxAspects().getTotal();
            int exact = aspectRange.getExact(aspect, (World)minecraft.world);
            String cheatsheet = "";
            IDrawableStatic ashBar = this.helper.createDrawable(this.resourceLocation, this.u, this.v, this.width * min / aspectTotal, this.height);
            IDrawableStatic ashPartialBar = this.helper.createDrawable(this.resourceLocation, this.u, this.v + this.height, this.width * max / aspectTotal, this.height);
            ashPartialBar.draw(minecraft, x, y);
            ashBar.draw(minecraft, x, y);
            Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(min + "-" + max + cheatsheet, (float)(x + this.width + 3), (float)(y - 1), 0xFFFFFF);
        }
    }
}

