/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityMixerTop;
import teamroots.embers.util.FluidUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityMixerBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
IMechanicallyPowered,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double EMBER_COST = ConfigMachine.MIXER.ember_cost;
    public static final int CAPACITY = ConfigMachine.MIXER.input_capacity;
    public FluidTank north = new FluidTank(CAPACITY);
    public FluidTank south = new FluidTank(CAPACITY);
    public FluidTank east = new FluidTank(CAPACITY);
    public FluidTank west = new FluidTank(CAPACITY);
    public FluidTank[] tanks;
    Random random = new Random();
    int progress = -1;
    boolean isWorking;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    private List<IUpgradeProvider> upgrades;
    private double powerRatio;

    public TileEntityMixerBottom() {
        this.tanks = new FluidTank[]{this.north, this.south, this.east, this.west};
    }

    public FluidTank[] getTanks() {
        return this.tanks;
    }

    public ArrayList<FluidStack> getFluids() {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        if (this.north.getFluid() != null) {
            fluids.add(this.north.getFluid());
        }
        if (this.south.getFluid() != null) {
            fluids.add(this.south.getFluid());
        }
        if (this.east.getFluid() != null) {
            fluids.add(this.east.getFluid());
        }
        if (this.west.getFluid() != null) {
            fluids.add(this.west.getFluid());
        }
        return fluids;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagCompound northTank = new NBTTagCompound();
        this.north.writeToNBT(northTank);
        tag.setTag("northTank", (NBTBase)northTank);
        NBTTagCompound southTank = new NBTTagCompound();
        this.south.writeToNBT(southTank);
        tag.setTag("southTank", (NBTBase)southTank);
        NBTTagCompound eastTank = new NBTTagCompound();
        this.east.writeToNBT(eastTank);
        tag.setTag("eastTank", (NBTBase)eastTank);
        NBTTagCompound westTank = new NBTTagCompound();
        this.west.writeToNBT(westTank);
        tag.setTag("westTank", (NBTBase)westTank);
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.north.readFromNBT(tag.getCompoundTag("northTank"));
        this.south.readFromNBT(tag.getCompoundTag("southTank"));
        this.east.readFromNBT(tag.getCompoundTag("eastTank"));
        this.west.readFromNBT(tag.getCompoundTag("westTank"));
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: 
                case UP: {
                    break;
                }
                case EAST: {
                    return (T)this.east;
                }
                case NORTH: {
                    return (T)this.north;
                }
                case SOUTH: {
                    return (T)this.south;
                }
                case WEST: {
                    return (T)this.west;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        TileEntityMixerTop top = (TileEntityMixerTop)world.getTileEntity(pos.up());
        this.isWorking = false;
        if (top != null) {
            boolean cancel;
            this.upgrades = UpgradeUtil.getUpgrades(world, pos.up(), EnumFacing.VALUES);
            if (this.upgrades.isEmpty()) {
                this.upgrades = UpgradeUtil.getUpgrades(world, pos, EnumFacing.VALUES);
            }
            UpgradeUtil.verifyUpgrades(this, this.upgrades);
            if (UpgradeUtil.doTick(this, this.upgrades)) {
                return;
            }
            ArrayList<FluidStack> fluids = this.getFluids();
            FluidMixingRecipe recipe = this.getRecipe(fluids);
            this.powerRatio = recipe != null ? recipe.getPowerRatio() : 0.0;
            double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, this.upgrades);
            if (top.capability.getEmber() >= emberCost && recipe != null && !(cancel = UpgradeUtil.doWork(this, this.upgrades))) {
                IFluidHandler tank = (IFluidHandler)top.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                FluidStack output = recipe.getResult(fluids);
                int amount = tank.fill(output = UpgradeUtil.transformOutput((TileEntity)this, output, this.upgrades), false);
                if (amount != 0) {
                    UpgradeUtil.throwEvent(this, new MachineRecipeEvent.Success<FluidMixingRecipe>(this, recipe), this.upgrades);
                    this.isWorking = true;
                    tank.fill(output, true);
                    this.consumeFluids(recipe);
                    UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
                    top.capability.removeAmount(emberCost, true);
                    this.markDirty();
                    top.markDirty();
                }
            }
        }
    }

    private FluidMixingRecipe getRecipe(ArrayList<FluidStack> fluids) {
        FluidMixingRecipe recipe = RecipeRegistry.getMixingRecipe(fluids);
        MachineRecipeEvent<FluidMixingRecipe> event = new MachineRecipeEvent<FluidMixingRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        return event.getRecipe();
    }

    public void consumeFluids(FluidMixingRecipe recipe) {
        for (int j = 0; j < recipe.inputs.size(); ++j) {
            FluidStack recipeFluid = recipe.inputs.get(j).copy();
            for (FluidTank tank : this.tanks) {
                FluidStack tankFluid = tank.getFluid();
                if (recipeFluid == null || tankFluid == null || !FluidUtil.areFluidsEqual(recipeFluid.getFluid(), tankFluid.getFluid())) continue;
                FluidStack stack = tank.drain(recipeFluid.amount, true);
                recipeFluid.amount = recipeFluid.amount - (stack != null ? stack.amount : 0);
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.MIXER_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 1.0f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType)) {
            information.clear();
            information.add(TextFormatting.BOLD.toString() + I18n.format((String)"embers.tooltip.side.north", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.north.getFluid(), this.north.getCapacity()));
            information.add(TextFormatting.BOLD.toString() + I18n.format((String)"embers.tooltip.side.east", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.east.getFluid(), this.east.getCapacity()));
            information.add(TextFormatting.BOLD.toString() + I18n.format((String)"embers.tooltip.side.south", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.south.getFluid(), this.south.getCapacity()));
            information.add(TextFormatting.BOLD.toString() + I18n.format((String)"embers.tooltip.side.west", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.west.getFluid(), this.south.getCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.metal", (Object[])new Object[0])));
    }

    @Override
    public double getMinimumPower() {
        return 20.0;
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Misc.getDiminishedPower(power, 80.0, 0.01875);
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public double getStandardPowerRatio() {
        return this.powerRatio;
    }
}

