/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.IUpgradeProxy;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityMechCore
extends TileEntity
implements ITileEntityBase,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeProxy {
    Random random = new Random();

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return super.writeToNBT(tag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public TileEntity getAttachedMultiblock() {
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.DOWN)) instanceof IMultiblockMachine) {
            return this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.DOWN));
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.UP)) instanceof IMultiblockMachine) {
            return this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.UP));
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.WEST)) instanceof IMultiblockMachine) {
            return this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.WEST));
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.EAST)) instanceof IMultiblockMachine) {
            return this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.EAST));
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.NORTH)) instanceof IMultiblockMachine) {
            return this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.NORTH));
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.SOUTH)) instanceof IMultiblockMachine) {
            return this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.SOUTH));
        }
        return null;
    }

    public EnumFacing getAttachedSide() {
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.DOWN)) instanceof IMultiblockMachine) {
            return EnumFacing.DOWN;
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.UP)) instanceof IMultiblockMachine) {
            return EnumFacing.UP;
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.WEST)) instanceof IMultiblockMachine) {
            return EnumFacing.WEST;
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.EAST)) instanceof IMultiblockMachine) {
            return EnumFacing.EAST;
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.NORTH)) instanceof IMultiblockMachine) {
            return EnumFacing.NORTH;
        }
        if (this.getWorld().getTileEntity(this.getPos().offset(EnumFacing.SOUTH)) instanceof IMultiblockMachine) {
            return EnumFacing.SOUTH;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        TileEntity multiblock = this.getAttachedMultiblock();
        if (multiblock != null) {
            return multiblock.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        TileEntity multiblock = this.getAttachedMultiblock();
        if (multiblock != null) {
            return (T)multiblock.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        TileEntity multiblock = this.getAttachedMultiblock();
        if (multiblock instanceof IExtraDialInformation) {
            ((IExtraDialInformation)multiblock).addDialInformation(facing, information, dialType);
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        TileEntity multiblock = this.getAttachedMultiblock();
        if (multiblock instanceof IExtraCapabilityInformation) {
            return ((IExtraCapabilityInformation)multiblock).hasCapabilityDescription(capability);
        }
        return false;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        TileEntity multiblock = this.getAttachedMultiblock();
        if (multiblock instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)multiblock).addCapabilityDescription(strings, capability, facing);
        }
    }

    @Override
    public void addOtherDescription(List<String> strings, EnumFacing facing) {
        TileEntity multiblock = this.getAttachedMultiblock();
        if (multiblock instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)multiblock).addOtherDescription(strings, facing);
        }
    }

    @Override
    public void collectUpgrades(List<IUpgradeProvider> upgrades) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            if (!this.isSocket(facing)) continue;
            UpgradeUtil.collectUpgrades(this.world, this.pos.offset(facing), facing.getOpposite(), upgrades);
        }
    }

    @Override
    public boolean isSocket(EnumFacing facing) {
        EnumFacing attachedSide = this.getAttachedSide();
        return facing != attachedSide;
    }

    @Override
    public boolean isProvider(EnumFacing facing) {
        EnumFacing attachedSide = this.getAttachedSide();
        return facing == attachedSide;
    }
}

