/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import mysticalmechanics.api.GearHelperTile;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import teamroots.embers.block.BlockMechActuator;
import teamroots.embers.tileentity.TileEntityMechActuator;

public class TileEntityMechActuatorRenderer
extends TileEntitySpecialRenderer<TileEntityMechActuator> {
    public void render(TileEntityMechActuator tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        IBlockState state;
        if (tile != null && (state = tile.getWorld().getBlockState(tile.getPos())).getBlock() instanceof BlockMechActuator) {
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            ItemStack gearHologram = player.getHeldItemMainhand();
            for (int i = 0; i < 6; ++i) {
                EnumFacing face = EnumFacing.byIndex((int)i);
                GearHelperTile gear = tile.gears[i];
                boolean sideHit = MysticalMechanicsAPI.IMPL.isGearHit((TileEntity)tile, face);
                boolean renderHologram = MysticalMechanicsAPI.IMPL.shouldRenderHologram(gearHologram, !gear.isEmpty(), sideHit, tile.canAttachGear(face, gearHologram));
                if (gear.isEmpty() && !renderHologram) continue;
                GlStateManager.disableCull();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.pushMatrix();
                GlStateManager.translate((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                switch (face) {
                    case DOWN: {
                        GlStateManager.rotate((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case UP: {
                        GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.rotate((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                MysticalMechanicsAPI.IMPL.renderGear(gear.getGear(), gearHologram, renderHologram, partialTicks, -0.375, 0.875, (float)gear.getPartialAngle((double)partialTicks));
                GlStateManager.popMatrix();
            }
        }
    }
}

