/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.api.filter.FilterItem;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.item.IFilterItem;
import teamroots.embers.block.BlockItemTransfer;
import teamroots.embers.tileentity.TileEntityItemPipeBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Misc;

public class TileEntityItemTransfer
extends TileEntityItemPipeBase {
    public static final int PRIORITY_TRANSFER = -10;
    double angle = 0.0;
    double turnRate = 1.0;
    public ItemStack filterItem = ItemStack.EMPTY;
    Random random = new Random();
    boolean syncFilter;
    IItemHandler outputSide;
    IFilter filter = FilterUtil.FILTER_ANY;

    @Override
    protected void initInventory() {
        this.inventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return TileEntityItemTransfer.this.getCapacity();
            }

            protected void onContentsChanged(int slot) {
                TileEntityItemTransfer.this.markDirty();
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (TileEntityItemTransfer.this.acceptsItem(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
        this.outputSide = Misc.makeRestrictedItemHandler((IItemHandler)this.inventory, false, true);
    }

    public boolean acceptsItem(ItemStack stack) {
        return this.filter.acceptsItem(stack);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.writeFilter(tag);
        return tag;
    }

    private void writeFilter(NBTTagCompound tag) {
        if (!this.filterItem.isEmpty()) {
            tag.setTag("filter", (NBTBase)this.filterItem.writeToNBT(new NBTTagCompound()));
        } else {
            tag.setString("filter", "empty");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("filter")) {
            this.filterItem = new ItemStack(tag.getCompoundTag("filter"));
        }
        this.setupFilter();
    }

    @Override
    public NBTTagCompound getSyncTag() {
        NBTTagCompound compound = super.getUpdateTag();
        if (this.syncFilter) {
            this.writeFilter(compound);
        }
        return compound;
    }

    @Override
    protected boolean requiresSync() {
        return this.syncFilter || super.requiresSync();
    }

    @Override
    protected void resetSync() {
        super.resetSync();
        this.syncFilter = false;
    }

    @Override
    int getCapacity() {
        return 4;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return facing == null || facing.getAxis() == this.getFacing().getAxis();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            EnumFacing transferFacing = this.getFacing();
            if (facing == transferFacing) {
                return (T)this.outputSide;
            }
            if (facing == null || facing.getAxis() == transferFacing.getAxis()) {
                return (T)this.inventory;
            }
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getFacing() {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        return (EnumFacing)state.getValue((IProperty)BlockItemTransfer.facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!world.isRemote) {
            if (heldItem != ItemStack.EMPTY) {
                this.filterItem = heldItem.copy();
                world.setBlockState(pos, state.withProperty((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(true)), 10);
            } else {
                this.filterItem = ItemStack.EMPTY;
                world.setBlockState(pos, state.withProperty((IProperty)BlockItemTransfer.filter, (Comparable)Boolean.valueOf(false)), 10);
            }
            this.setupFilter();
            this.syncFilter = true;
            this.markDirty();
            return true;
        }
        return true;
    }

    private void setupFilter() {
        Item item = this.filterItem.getItem();
        this.filter = item instanceof IFilterItem ? ((IFilterItem)item).getFilter(this.filterItem) : (!this.filterItem.isEmpty() ? new FilterItem(this.filterItem) : FilterUtil.FILTER_ANY);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.getBlock() != newSate.getBlock();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    @Override
    public void update() {
        if (this.world.isRemote && this.clogged && this.isAnySideUnclogged()) {
            Misc.spawnClogParticles(this.world, this.pos, 2, 0.7f);
        }
        this.angle += this.turnRate;
        super.update();
    }

    @Override
    public int getPriority(EnumFacing facing) {
        return -10;
    }

    @Override
    public EnumPipeConnection getInternalConnection(EnumFacing facing) {
        return EnumPipeConnection.NONE;
    }

    @Override
    void setInternalConnection(EnumFacing facing, EnumPipeConnection connection) {
    }

    @Override
    boolean isConnected(EnumFacing facing) {
        return this.getFacing().getAxis() == facing.getAxis();
    }

    @Override
    protected boolean isFrom(EnumFacing facing) {
        return facing == this.getFacing().getOpposite();
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public EnumPipeConnection getConnection(EnumFacing facing) {
        if (this.getFacing().getAxis() == facing.getAxis()) {
            return EnumPipeConnection.PIPE;
        }
        return EnumPipeConnection.NONE;
    }
}

