/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import teamroots.embers.SoundManager;
import teamroots.embers.block.BlockInfernoForgeEdge;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityInfernoForge;
import teamroots.embers.util.Misc;

public class TileEntityInfernoForgeOpening
extends TileEntity
implements ITileEntityBase,
ITickable {
    public boolean isOpen;
    public boolean prevState;
    public float openAmount;
    public float lastOpenAmount;

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setBoolean("isOpen", this.isOpen);
        tag.setBoolean("prevState", this.prevState);
        tag.setFloat("openAmount", this.openAmount);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.isOpen = tag.getBoolean("isOpen");
        this.prevState = tag.getBoolean("prevState");
        this.openAmount = tag.getFloat("openAmount");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public void toggle() {
        if (this.isOpen) {
            this.close();
        } else {
            this.open();
        }
    }

    public void open() {
        this.isOpen = true;
        this.prevState = false;
        this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, SoundManager.INFERNO_FORGE_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.markDirty();
    }

    public void close() {
        this.isOpen = false;
        this.prevState = true;
        this.world.playSound(null, (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 0.5, (double)this.getPos().getZ() + 0.5, SoundManager.INFERNO_FORGE_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.markDirty();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityInfernoForge forge;
        if (!player.isSneaking() && world.getTileEntity(pos.down()) instanceof TileEntityInfernoForge && (forge = this.getForge(world, pos)) != null && forge.progress == 0) {
            if (this.isOpen && forge.capability.getEmber() <= 0.0) {
                if (!world.isRemote) {
                    player.sendStatusMessage((ITextComponent)new TextComponentTranslation("embers.tooltip.forge.cannot_start", new Object[0]), true);
                }
                return true;
            }
            this.toggle();
            return true;
        }
        return false;
    }

    private TileEntityInfernoForge getForge(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos.down());
        return tile instanceof TileEntityInfernoForge ? (TileEntityInfernoForge)tile : null;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        BlockInfernoForgeEdge.breakBlockSafe(world, pos.down(), player);
        world.setTileEntity(pos, null);
    }

    public void update() {
        this.lastOpenAmount = this.openAmount;
        if (this.isOpen && !this.prevState && this.openAmount < 1.0f) {
            this.openAmount = 0.5f + 0.5f * this.openAmount;
            if (this.openAmount > 0.99f) {
                this.openAmount = 1.0f;
                this.prevState = this.isOpen;
                this.markDirty();
            }
        }
        if (!this.isOpen && this.prevState && this.openAmount > 0.0f) {
            this.openAmount = 0.5f * this.openAmount;
            if (this.openAmount < 0.01f) {
                this.openAmount = 0.0f;
                TileEntityInfernoForge forge = this.getForge(this.world, this.pos);
                if (forge != null) {
                    forge.updateProgress();
                }
                this.prevState = this.isOpen;
                this.markDirty();
            }
        }
    }
}

