/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.HeatCoilVisualEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageCookItemFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.recipe.HeatCoilRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityHeatCoil
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double EMBER_COST = ConfigMachine.HEAT_COIL.ember_cost;
    public static final double HEATING_SPEED = ConfigMachine.HEAT_COIL.heating_speed;
    public static final double COOLING_SPEED = ConfigMachine.HEAT_COIL.cooling_speed;
    public static final double MAX_HEAT = ConfigMachine.HEAT_COIL.max_heat;
    public static final int MIN_COOK_TIME = ConfigMachine.HEAT_COIL.min_cook_time;
    public static final int MAX_COOK_TIME = ConfigMachine.HEAT_COIL.max_cook_time;
    public static final Color DEFAULT_COLOR = new Color(255, 64, 16);
    public IEmberCapability capability = new DefaultEmberCapability();
    public ItemStackHandler inventory = new ItemStackHandler(1);
    protected Random random = new Random();
    protected int progress = 0;
    public double heat = 0.0;
    protected int ticksExisted = 0;
    public static final int SOUND_LOW_LOOP = 1;
    public static final int SOUND_MID_LOOP = 2;
    public static final int SOUND_HIGH_LOOP = 3;
    public static final int SOUND_PROCESS = 4;
    public static final int[] SOUND_IDS = new int[]{1, 2, 3, 4};
    HashSet<Integer> soundsPlaying = new HashSet();
    boolean isWorking;
    private List<IUpgradeProvider> upgrades;

    public TileEntityHeatCoil() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", this.progress);
        tag.setDouble("heat", this.heat);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
        if (tag.hasKey("heat")) {
            this.heat = tag.getDouble("heat");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setBlockToAir(pos.add(1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, 0));
        world.setBlockToAir(pos.add(0, 0, -1));
        world.setBlockToAir(pos.add(1, 0, -1));
        world.setBlockToAir(pos.add(-1, 0, 1));
        world.setBlockToAir(pos.add(1, 0, 1));
        world.setBlockToAir(pos.add(-1, 0, -1));
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        ++this.ticksExisted;
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, new EnumFacing[]{EnumFacing.DOWN});
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, this.upgrades);
        if (this.capability.getEmber() >= emberCost) {
            UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
            this.capability.removeAmount(emberCost, true);
            if (this.ticksExisted % 20 == 0) {
                this.heat += UpgradeUtil.getOtherParameter((TileEntity)this, "heating_speed", HEATING_SPEED, this.upgrades);
            }
        } else if (this.ticksExisted % 20 == 0) {
            this.heat -= UpgradeUtil.getOtherParameter((TileEntity)this, "cooling_speed", COOLING_SPEED, this.upgrades);
        }
        double maxHeat = UpgradeUtil.getOtherParameter((TileEntity)this, "max_heat", MAX_HEAT, this.upgrades);
        this.heat = MathHelper.clamp((double)this.heat, (double)0.0, (double)maxHeat);
        this.isWorking = false;
        boolean cancel = UpgradeUtil.doWork(this, this.upgrades);
        int cookTime = UpgradeUtil.getWorkTime(this, (int)Math.ceil(MathHelper.clampedLerp((double)MIN_COOK_TIME, (double)MAX_COOK_TIME, (double)(1.0 - this.heat / maxHeat))), this.upgrades);
        if (!cancel && this.heat > 0.0 && this.ticksExisted % cookTime == 0 && !this.getWorld().isRemote) {
            int i;
            EntityItem entityItem;
            HeatCoilRecipe recipe;
            List items = this.getWorld().getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB((double)(this.getPos().getX() - 1), (double)this.getPos().getY(), (double)(this.getPos().getZ() - 1), (double)(this.getPos().getX() + 2), (double)(this.getPos().getY() + 2), (double)(this.getPos().getZ() + 2)));
            for (EntityItem item : items) {
                item.setAgeToCreativeDespawnTime();
                item.lifespan = 10800;
            }
            if (items.size() > 0 && (recipe = this.getRecipe(entityItem = (EntityItem)items.get(i = this.random.nextInt(items.size())))) != null) {
                ArrayList returns = Lists.newArrayList((Object[])new ItemStack[]{recipe.getResult(this, entityItem.getItem())});
                int inputCount = recipe.getInputConsumed();
                boolean dirty = false;
                UpgradeUtil.throwEvent(this, new MachineRecipeEvent.Success<HeatCoilRecipe>(this, recipe), this.upgrades);
                UpgradeUtil.transformOutput((TileEntity)this, returns, this.upgrades);
                this.depleteItem(entityItem, inputCount);
                for (ItemStack stack : returns) {
                    ItemStack remainder = this.inventory.insertItem(0, stack, false);
                    dirty = true;
                    if (remainder.isEmpty()) continue;
                    this.getWorld().spawnEntity((Entity)new EntityItem(this.getWorld(), entityItem.posX, entityItem.posY, entityItem.posZ, remainder));
                }
                if (dirty) {
                    this.markDirty();
                }
            }
        }
        if (this.getWorld().isRemote && this.heat > 0.0) {
            int particleCount = (int)((float)(1 + this.random.nextInt(2)) * (1.0f + (float)Math.sqrt(this.heat)));
            HeatCoilVisualEvent event = new HeatCoilVisualEvent(this, DEFAULT_COLOR, particleCount, 0.0f);
            UpgradeUtil.throwEvent(this, event, this.upgrades);
            Color color = event.getColor();
            for (int i = 0; i < event.getParticles(); ++i) {
                ParticleUtil.spawnParticleGlow(this.getWorld(), (float)this.getPos().getX() - 0.2f + this.random.nextFloat() * 1.4f, (float)this.getPos().getY() + 1.275f, (float)this.getPos().getZ() - 0.2f + this.random.nextFloat() * 1.4f, 0.0f, this.random.nextFloat() * event.getVerticalSpeed(), 0.0f, color.getRed(), color.getGreen(), color.getBlue(), 2.0f, 24);
            }
        }
    }

    private HeatCoilRecipe getRecipe(EntityItem entityItem) {
        HeatCoilRecipe recipe = RecipeRegistry.getHeatCoilRecipe(entityItem.getItem());
        MachineRecipeEvent<HeatCoilRecipe> event = new MachineRecipeEvent<HeatCoilRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        return event.getRecipe();
    }

    public void depleteItem(EntityItem entityItem, int inputCount) {
        ItemStack stack = entityItem.getItem();
        stack.shrink(inputCount);
        entityItem.setItem(stack);
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageCookItemFX(entityItem.posX, entityItem.posY, entityItem.posZ));
        if (stack.isEmpty()) {
            entityItem.setDead();
            this.getWorld().removeEntity((Entity)entityItem);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.HEATCOIL_LOW, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.HEATCOIL_MID, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
                break;
            }
            case 3: {
                Embers.proxy.playMachineSound(this, 3, SoundManager.HEATCOIL_HIGH, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
                break;
            }
            case 4: {
                Embers.proxy.playMachineSound(this, 4, SoundManager.HEATCOIL_COOK, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        double heatRatio = this.heat / MAX_HEAT;
        float highVolume = (float)MathHelper.clampedLerp((double)0.0, (double)1.0, (double)((heatRatio - 0.75) * 4.0));
        float midVolume = (float)MathHelper.clampedLerp((double)0.0, (double)1.0, (double)((heatRatio - 0.25) * 4.0)) - highVolume;
        float lowVolume = (float)MathHelper.clampedLerp((double)0.0, (double)1.0, (double)(heatRatio * 10.0)) - midVolume;
        switch (id) {
            case 1: {
                return lowVolume > 0.0f;
            }
            case 2: {
                return midVolume > 0.0f;
            }
            case 3: {
                return highVolume > 0.0f;
            }
        }
        return false;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        double heatRatio = this.heat / MAX_HEAT;
        float highVolume = (float)MathHelper.clampedLerp((double)0.0, (double)1.0, (double)((heatRatio - 0.75) * 4.0));
        float midVolume = (float)MathHelper.clampedLerp((double)0.0, (double)1.0, (double)((heatRatio - 0.25) * 4.0)) - highVolume;
        float lowVolume = (float)MathHelper.clampedLerp((double)0.0, (double)1.0, (double)(heatRatio * 10.0)) - midVolume;
        switch (id) {
            case 1: {
                return lowVolume;
            }
            case 2: {
                return midVolume;
            }
            case 3: {
                return highVolume;
            }
        }
        return 0.0f;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("ember".equals(dialType)) {
            DecimalFormat heatFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.heat");
            double maxHeat = UpgradeUtil.getOtherParameter((TileEntity)this, "max_heat", MAX_HEAT, this.upgrades);
            double heat = MathHelper.clamp((double)this.heat, (double)0.0, (double)maxHeat);
            information.add(I18n.format((String)"embers.tooltip.dial.heat", (Object[])new Object[]{heatFormat.format(heat), heatFormat.format(maxHeat)}));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", null));
        }
    }
}

