/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityOpenTank;
import teamroots.embers.util.FluidColorHelper;
import teamroots.embers.util.Misc;

public class TileEntityFurnaceTop
extends TileEntityOpenTank
implements ITileEntityBase,
ITickable,
IExtraCapabilityInformation {
    public static int capacity = ConfigMachine.MELTER.tankSize;
    public double angle = 0.0;
    int ticksExisted = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityFurnaceTop.this.markDirty();
        }
    };

    public TileEntityFurnaceTop() {
        this.tank = new FluidTank(capacity){

            public void onContentsChanged() {
                TileEntityFurnaceTop.this.markDirty();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (Misc.isGaseousFluid(resource)) {
                    TileEntityFurnaceTop.this.setEscapedFluid(resource);
                    return resource.amount;
                }
                return super.fill(resource, doFill);
            }
        };
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("inventory")) {
            this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItemMainhand();
        if (!heldItem.isEmpty()) {
            boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
            if (didFill) {
                this.markDirty();
                return true;
            }
            player.setHeldItem(hand, this.inventory.insertItem(0, heldItem, false));
            this.markDirty();
            return true;
        }
        if (!this.inventory.getStackInSlot(0).isEmpty() && !world.isRemote) {
            world.spawnEntity((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, this.inventory.getStackInSlot(0)));
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            this.markDirty();
            return true;
        }
        return false;
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE((TileEntity)this);
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Deprecated
    public Fluid getFluid() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    @Deprecated
    public int getAmount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void update() {
        this.angle += 1.0;
        ++this.ticksExisted;
        if (this.ticksExisted % 10 == 0) {
            List<EntityItem> items = this.onGetEntitiesWithinAABB(this.getWorld(), EntityItem.class, new AxisAlignedBB((double)this.getPos().getX(), (double)this.getPos().getY(), (double)this.getPos().getZ(), (double)(this.getPos().getX() + 1), (double)this.getPos().getY() + 1.25, (double)(this.getPos().getZ() + 1)));
            for (EntityItem item : items) {
                ItemStack stack = this.inventory.insertItem(0, item.getItem(), false);
                if (!stack.isEmpty()) {
                    item.setItem(stack);
                    continue;
                }
                this.getWorld().removeEntity((Entity)item);
            }
        }
        if (this.world.isRemote && this.shouldEmitParticles()) {
            this.updateEscapeParticles();
        }
    }

    @Override
    protected void updateEscapeParticles() {
        Color fluidColor = new Color(FluidColorHelper.getColor(this.lastEscaped), true);
        Random random = new Random();
        for (int i = 0; i < 3; ++i) {
            float xOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.2f;
            float yOffset = 0.9f;
            float zOffset = 0.5f + (random.nextFloat() - 0.5f) * 2.0f * 0.2f;
            ParticleUtil.spawnParticleVapor(this.world, (float)this.pos.getX() + xOffset, (float)this.pos.getY() + yOffset, (float)this.pos.getZ() + zOffset, 0.0f, 0.05f, 0.0f, (float)fluidColor.getRed() / 255.0f, (float)fluidColor.getGreen() / 255.0f, (float)fluidColor.getBlue() / 255.0f, (float)fluidColor.getAlpha() / 255.0f, 4.0f, 2.0f, 20);
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", null));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.fluid", I18n.format((String)"embers.tooltip.goggles.fluid.metal", (Object[])new Object[0])));
        }
    }

    private <T extends Entity> List<T> onGetEntitiesWithinAABB(World world, Class<T> entityClass, AxisAlignedBB axisAlignedBB) {
        return world.getEntitiesWithinAABB(entityClass, axisAlignedBB, entity -> EntitySelectors.NOT_SPECTATING.apply(entity) && entity.isEntityAlive());
    }
}

