/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityFurnaceTop;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityFurnaceBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController {
    public static int PROCESS_TIME = ConfigMachine.MELTER.processTime;
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    int progress = -1;
    public static double EMBER_COST = ConfigMachine.MELTER.emberCost;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    boolean isWorking;
    private List<IUpgradeProvider> upgrades;

    public TileEntityFurnaceBottom() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        if (tag.hasKey("progress")) {
            this.progress = tag.getInteger("progress");
        }
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        world.setTileEntity(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public void update() {
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        TileEntityFurnaceTop top = (TileEntityFurnaceTop)this.world.getTileEntity(this.getPos().up());
        this.upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.HORIZONTALS);
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        if (top != null && !top.inventory.getStackInSlot(0).isEmpty()) {
            boolean cancel;
            double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, this.upgrades);
            if (this.capability.getEmber() >= emberCost && !(cancel = UpgradeUtil.doWork(this, this.upgrades))) {
                ItemStack recipeStack;
                ItemMeltingRecipe recipe;
                UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
                this.capability.removeAmount(emberCost, true);
                if (this.world.isRemote) {
                    if (this.random.nextInt(20) == 0) {
                        ParticleUtil.spawnParticleSpark(this.world, (float)this.getPos().getX() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.getPos().getY() + 1.25f, (float)this.getPos().getZ() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                    }
                    if (this.random.nextInt(10) == 0) {
                        for (int i = 0; i < 12; ++i) {
                            ParticleUtil.spawnParticleSmoke(this.world, (float)this.getPos().getX() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.getPos().getY() + 1.25f, (float)this.getPos().getZ() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.0f, 0.03125f + 0.03125f * this.random.nextFloat(), 0.0f, 64.0f, 64.0f, 64.0f, 0.125f, 5.0f + 3.0f * this.random.nextFloat(), 80);
                        }
                    }
                }
                this.isWorking = true;
                ++this.progress;
                this.markDirty();
                if (this.progress >= UpgradeUtil.getWorkTime(this, PROCESS_TIME, this.upgrades) && (recipe = this.getRecipe(recipeStack = top.inventory.getStackInSlot(0))) != null && !this.world.isRemote) {
                    FluidStack output = recipe.getResult(this, recipeStack);
                    FluidTank tank = top.getTank();
                    if ((output = UpgradeUtil.transformOutput((TileEntity)this, output, this.upgrades)) != null && tank.fill(output, false) >= output.amount) {
                        tank.fill(output, true);
                        top.markDirty();
                        top.inventory.extractItem(0, recipe.getInputConsumed(), false);
                        this.progress = 0;
                        UpgradeUtil.throwEvent(this, new MachineRecipeEvent.Success<ItemMeltingRecipe>(this, recipe), this.upgrades);
                        this.markDirty();
                    }
                }
            }
        } else {
            this.isWorking = false;
            if (this.progress > 0) {
                this.progress = 0;
                this.markDirty();
            }
        }
    }

    private ItemMeltingRecipe getRecipe(ItemStack recipeStack) {
        ItemMeltingRecipe recipe = RecipeRegistry.getMeltingRecipe(recipeStack);
        MachineRecipeEvent<ItemMeltingRecipe> event = new MachineRecipeEvent<ItemMeltingRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        return event.getRecipe();
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.MELTER_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 1.0f, (float)this.pos.getZ() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }
}

