/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import teamroots.embers.tileentity.TileEntityFieldChart;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.RenderUtil;

public class TileEntityFieldChartRenderer
extends TileEntitySpecialRenderer<TileEntityFieldChart> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/field_square.png");

    public void render(TileEntityFieldChart tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.disableLighting();
            GlStateManager.enableAlpha();
            int dfunc = GL11.glGetInteger((int)2932);
            GlStateManager.depthFunc((int)515);
            int func = GL11.glGetInteger((int)3009);
            float ref = GL11.glGetFloat((int)3010);
            GlStateManager.alphaFunc((int)519, (float)0.0f);
            Tessellator tess = Tessellator.getInstance();
            GlStateManager.shadeModel((int)7425);
            GlStateManager.depthMask((boolean)false);
            long seed = tile.getWorld().getSeed();
            this.renderChart(tile, x, y, z, tess, (cx, cz) -> EmberGenUtil.getEmberDensity(seed, cx, cz), new Color(255, 64, 16), new Color(255, 192, 16), new Color(255, 255, 8));
            this.renderChart(tile, x, y, z, tess, (cx, cz) -> {
                float v = EmberGenUtil.getEmberStability(seed, cx, cz);
                return v * v * v;
            }, new Color(16, 64, 255), new Color(16, 192, 255), new Color(8, 255, 255));
            GlStateManager.depthMask((boolean)true);
            GlStateManager.shadeModel((int)7424);
            GlStateManager.alphaFunc((int)func, (float)ref);
            GlStateManager.depthFunc((int)dfunc);
            GlStateManager.enableLighting();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.disableAlpha();
            GlStateManager.disableBlend();
        }
    }

    public void renderChart(TileEntityFieldChart tile, double x, double y, double z, Tessellator tess, IChartSource source, Color color1, Color color2, Color color3) {
        BufferBuilder buffer = tess.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
        float red1 = (float)color1.getRed() / 255.0f;
        float green1 = (float)color1.getGreen() / 255.0f;
        float blue1 = (float)color1.getBlue() / 255.0f;
        float alpha1 = (float)color1.getAlpha() / 255.0f;
        for (float i = -160.0f; i < 160.0f; i += 32.0f) {
            for (float j = -160.0f; j < 160.0f; j += 32.0f) {
                float amountul = source.get(tile.getPos().getX() + (int)i / 2, tile.getPos().getZ() + (int)j / 2);
                float amountur = source.get(tile.getPos().getX() + (int)i / 2 + 16, tile.getPos().getZ() + (int)j / 2);
                float amountdr = source.get(tile.getPos().getX() + (int)i / 2 + 16, tile.getPos().getZ() + (int)j / 2 + 16);
                float amountdl = source.get(tile.getPos().getX() + (int)i / 2, tile.getPos().getZ() + (int)j / 2 + 16);
                float alphaul = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j)) / 160.0f));
                float alphaur = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j)) / 160.0f));
                float alphadr = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j + 32.0f)) / 160.0f));
                float alphadl = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j + 32.0f)) / 160.0f));
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)), y + 0.5 + (double)(amountul * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f))).tex(0.0, 0.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red1, green1, blue1, alpha1 * alphaul).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)) + 0.25, y + 0.5 + (double)(amountur * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f))).tex(1.0, 0.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red1, green1, blue1, alpha1 * alphaur).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)) + 0.25, y + 0.5 + (double)(amountdr * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f)) + 0.25).tex(1.0, 1.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red1, green1, alpha1 * blue1, alphadr).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)), y + 0.5 + (double)(amountdl * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f)) + 0.25).tex(0.0, 1.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red1, green1, blue1, alpha1 * alphadl).endVertex();
            }
        }
        float red2 = (float)color2.getRed() / 255.0f;
        float green2 = (float)color2.getGreen() / 255.0f;
        float blue2 = (float)color2.getBlue() / 255.0f;
        float alpha2 = (float)color2.getAlpha() / 255.0f;
        for (float i = -160.0f; i < 160.0f; i += 32.0f) {
            for (float j = -160.0f; j < 160.0f; j += 32.0f) {
                float amountul = source.get(tile.getPos().getX() + (int)i / 2, tile.getPos().getZ() + (int)j / 2);
                float amountur = source.get(tile.getPos().getX() + (int)i / 2 + 16, tile.getPos().getZ() + (int)j / 2);
                float amountdr = source.get(tile.getPos().getX() + (int)i / 2 + 16, tile.getPos().getZ() + (int)j / 2 + 16);
                float amountdl = source.get(tile.getPos().getX() + (int)i / 2, tile.getPos().getZ() + (int)j / 2 + 16);
                float alphaul = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j)) / 160.0f) * amountul * amountul);
                float alphaur = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j)) / 160.0f) * amountur * amountur);
                float alphadr = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j + 32.0f)) / 160.0f) * amountdr * amountdr);
                float alphadl = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j + 32.0f)) / 160.0f) * amountdl * amountdl);
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)), y + 0.5 + (double)(amountul * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f))).tex(0.0, 0.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red2, green2, blue2, alpha2 * 0.875f * alphaul).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)) + 0.25, y + 0.5 + (double)(amountur * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f))).tex(1.0, 0.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red2, green2, blue2, alpha2 * 0.875f * alphaur).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)) + 0.25, y + 0.5 + (double)(amountdr * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f)) + 0.25).tex(1.0, 1.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red2, green2, blue2, alpha2 * 0.875f * alphadr).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)), y + 0.5 + (double)(amountdl * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f)) + 0.25).tex(0.0, 1.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red2, green2, blue2, alpha2 * 0.875f * alphadl).endVertex();
            }
        }
        float red3 = (float)color3.getRed() / 255.0f;
        float green3 = (float)color3.getGreen() / 255.0f;
        float blue3 = (float)color3.getBlue() / 255.0f;
        float alpha3 = (float)color3.getAlpha() / 255.0f;
        for (float i = -160.0f; i < 160.0f; i += 32.0f) {
            for (float j = -160.0f; j < 160.0f; j += 32.0f) {
                float amountul = source.get(tile.getPos().getX() + (int)i / 2, tile.getPos().getZ() + (int)j / 2);
                float amountur = source.get(tile.getPos().getX() + (int)i / 2 + 16, tile.getPos().getZ() + (int)j / 2);
                float amountdr = source.get(tile.getPos().getX() + (int)i / 2 + 16, tile.getPos().getZ() + (int)j / 2 + 16);
                float amountdl = source.get(tile.getPos().getX() + (int)i / 2, tile.getPos().getZ() + (int)j / 2 + 16);
                float alphaul = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j)) / 160.0f) * amountul * amountul * amountul);
                float alphaur = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j)) / 160.0f) * amountur * amountur * amountur);
                float alphadr = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j + 32.0f)) / 160.0f) * amountdr * amountdr * amountdr);
                float alphadl = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j + 32.0f)) / 160.0f) * amountdl * amountdl * amountdl);
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)), y + 0.5 + (double)(amountul * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f))).tex(0.0, 0.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red3, green3, blue3, alpha3 * alphaul).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)) + 0.25, y + 0.5 + (double)(amountur * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f))).tex(1.0, 0.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red3, green3, blue3, alpha3 * alphaur).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)) + 0.25, y + 0.5 + (double)(amountdr * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f)) + 0.25).tex(1.0, 1.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red3, green3, blue3, alpha3 * alphadr).endVertex();
                buffer.pos(x + 0.5 + (double)(1.25f * (i / 160.0f)), y + 0.5 + (double)(amountdl * 0.25f), z + 0.5 + (double)(1.25f * (j / 160.0f)) + 0.25).tex(0.0, 1.0).lightmap(RenderUtil.lightx, RenderUtil.lighty).color(red3, green3, blue3, alpha3 * alphadl).endVertex();
            }
        }
        tess.draw();
    }

    static interface IChartSource {
        public float get(int var1, int var2);
    }
}

