/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.tile.IBin;
import teamroots.embers.api.tile.IHammerable;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageAnvilSparksFX;
import teamroots.embers.network.message.MessageStamperFX;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.tileentity.ISpecialFilter;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBin;
import teamroots.embers.util.FilterUtil;
import teamroots.embers.util.Misc;

public class TileEntityDawnstoneAnvil
extends TileEntity
implements ITileEntityBase,
IHammerable,
ISpecialFilter {
    public static int MAX_HITS = ConfigMachine.DAWNSTONE_ANVIL.maxHits;
    int ticksExisted = 0;
    int progress = 0;
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityDawnstoneAnvil.this.markDirty();
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    Random random = new Random();

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.setInteger("progress", this.progress);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
        this.progress = tag.getInteger("progress");
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        block5: {
            ItemStack heldItem;
            block4: {
                heldItem = player.getHeldItem(hand);
                if (!heldItem.isEmpty() || hand != EnumHand.MAIN_HAND) break block4;
                boolean doContinue = true;
                for (int i = 1; i >= 0 && doContinue; --i) {
                    if (this.inventory.getStackInSlot(i).isEmpty() || world.isRemote) continue;
                    world.spawnEntity((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, this.inventory.getStackInSlot(i)));
                    this.inventory.setStackInSlot(i, ItemStack.EMPTY);
                    doContinue = false;
                    this.progress = 0;
                    this.markDirty();
                    return true;
                }
                break block5;
            }
            if (heldItem.getItem() == ItemRegister.TINKER_HAMMER) {
                this.onHit();
                return true;
            }
            if (heldItem.isEmpty() || hand != EnumHand.MAIN_HAND) break block5;
            ItemStack stack = heldItem.copy();
            ItemStack stack2 = heldItem.copy();
            stack2.setCount(1);
            boolean doContinue = true;
            for (int i = 0; i < 2 && doContinue; ++i) {
                if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
                this.inventory.insertItem(i, stack2, false);
                doContinue = false;
                player.getHeldItem(hand).shrink(1);
                if (player.getHeldItem(hand).getCount() == 0) {
                    player.setHeldItem(hand, ItemStack.EMPTY);
                }
                this.progress = 0;
                this.markDirty();
                return true;
            }
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public boolean isValid(ItemStack stack1, ItemStack stack2) {
        DawnstoneAnvilRecipe recipe = RecipeRegistry.getDawnstoneAnvilRecipe(stack1, stack2);
        return recipe != null;
    }

    public ItemStack[] getResult(ItemStack stack1, ItemStack stack2) {
        DawnstoneAnvilRecipe recipe = RecipeRegistry.getDawnstoneAnvilRecipe(stack1, stack2);
        if (recipe != null) {
            this.inventory.setStackInSlot(1, ItemStack.EMPTY);
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
            this.markDirty();
            List<ItemStack> results = recipe.getResult(this, stack1, stack2);
            return results.toArray(new ItemStack[results.size()]);
        }
        return new ItemStack[0];
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    public void onHit() {
        if (this.isValid(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1))) {
            ++this.progress;
            this.world.playSound((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), SoundEvents.BLOCK_ANVIL_LAND, SoundCategory.BLOCKS, 0.25f, 2.0f + this.random.nextFloat(), false);
            if (this.progress > MAX_HITS) {
                ItemStack[] results;
                this.progress = 0;
                for (ItemStack result : results = this.getResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1))) {
                    TileEntity bin = this.getWorld().getTileEntity(this.getPos().down());
                    if (bin instanceof IBin) {
                        ItemStack remainder = ((TileEntityBin)bin).getInventory().insertItem(0, result, false);
                        if (!remainder.isEmpty() && !this.getWorld().isRemote) {
                            EntityItem item = new EntityItem(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)((float)this.getPos().getY() + 1.0625f), (double)this.getPos().getZ() + 0.5, remainder);
                            this.getWorld().spawnEntity((Entity)item);
                        }
                        bin.markDirty();
                        this.markDirty();
                        continue;
                    }
                    if (this.world.isRemote) continue;
                    EntityItem item = new EntityItem(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)((float)this.getPos().getY() + 1.0625f), (double)this.getPos().getZ() + 0.5, result);
                    this.getWorld().spawnEntity((Entity)item);
                }
                if (!this.getWorld().isRemote) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageStamperFX((double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.0625, (double)this.getPos().getZ() + 0.5));
                }
                this.world.playSound((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), SoundEvents.BLOCK_ANVIL_LAND, SoundCategory.BLOCKS, 1.0f, 0.95f + this.random.nextFloat() * 0.1f, false);
            }
            this.markDirty();
            if (!this.getWorld().isRemote) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageAnvilSparksFX((double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.0625, (double)this.getPos().getZ() + 0.5));
            }
        }
    }

    @Override
    public void onHit(TileEntity hammer) {
        this.progress = MAX_HITS;
        this.onHit();
    }

    @Override
    public boolean isValid() {
        return this.isValid(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
    }

    @Override
    public IFilter getSpecialFilter() {
        return FilterUtil.FILTER_NOT_EXISTING;
    }
}

