/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.tileentity.TileEntityCrystalCell;

public class TileEntityCrystalCellRenderer
extends TileEntitySpecialRenderer<TileEntityCrystalCell> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/crystal_material.png");
    RenderItem renderItem = Minecraft.getMinecraft().getRenderItem();
    Random random = new Random();

    public void render(TileEntityCrystalCell tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            this.random.setSeed(tile.seed);
            float capacityFactor = 120000.0f;
            double emberCapacity = tile.renderCapacity;
            double lerpCapacity = emberCapacity * (double)partialTicks + tile.renderCapacityLast * (double)(1.0f - partialTicks);
            int numLayers = 2 + (int)Math.floor(lerpCapacity / (double)capacityFactor) + 1;
            int numLayersOld = numLayers - 1;
            float growthFactor = this.getGrowthFactor(capacityFactor, lerpCapacity);
            float layerHeight = 0.25f;
            float height = layerHeight * (float)numLayers * growthFactor + (float)numLayersOld * layerHeight * (1.0f - growthFactor);
            float[] widths = new float[numLayers + 1];
            float[] oldWidths = new float[numLayers + 1];
            for (float i = 0.0f; i < (float)(numLayers + 1); i += 1.0f) {
                float rand = this.random.nextFloat();
                widths[(int)i] = i < (float)numLayers / 2.0f ? i / ((float)numLayers / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayers : ((float)numLayers - i) / ((float)numLayers / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayers;
                if (i >= (float)numLayersOld) continue;
                oldWidths[(int)i] = (double)i < (double)numLayersOld / 2.0 ? i / ((float)numLayersOld / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayersOld : ((float)numLayersOld - i) / ((float)numLayersOld / 2.0f) * (layerHeight * 0.1875f + layerHeight * 0.09375f * rand) * (float)numLayersOld;
            }
            GlStateManager.pushAttrib();
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            GlStateManager.disableLighting();
            GlStateManager.enableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            int l = this.getWorld().getCombinedLight(tile.getPos(), 15);
            int lx = l >> 16 & 0xFFFF;
            int ly = l & 0xFFFF;
            for (float j = 0.0f; j < 12.0f; j += 1.0f) {
                GlStateManager.pushMatrix();
                float scale = j / 12.0f;
                GlStateManager.translate((double)(x + 0.5), (double)(y + (double)(height / 2.0f) + 1.5), (double)(z + 0.5));
                GlStateManager.scale((float)scale, (float)scale, (float)scale);
                GlStateManager.rotate((float)(partialTicks + (float)(tile.ticksExisted % 360L)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotate((float)(30.0f * (float)Math.sin(Math.toRadians(partialTicks / 3.0f + (float)tile.ticksExisted / 3.0f % 360.0f))), (float)1.0f, (float)0.0f, (float)0.0f);
                buffer.begin(7, DefaultVertexFormats.POSITION_TEX_LMAP_COLOR);
                for (int i = 0; i < widths.length - 1; ++i) {
                    float width = widths[i] * growthFactor + oldWidths[i] * (1.0f - growthFactor);
                    float nextWidth = widths[i + 1] * growthFactor + oldWidths[i + 1] * (1.0f - growthFactor);
                    buffer.pos((double)(-width), (double)(layerHeight * (float)i - height / 2.0f), (double)(-width)).tex(0.0, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)width, (double)(layerHeight * (float)i - height / 2.0f), (double)(-width)).tex(0.5, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)nextWidth, (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)(-nextWidth)).tex(0.5, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-nextWidth), (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)(-nextWidth)).tex(0.0, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-width), (double)(layerHeight * (float)i - height / 2.0f), (double)width).tex(0.0, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)width, (double)(layerHeight * (float)i - height / 2.0f), (double)width).tex(0.5, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)nextWidth, (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)nextWidth).tex(0.5, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-nextWidth), (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)nextWidth).tex(0.0, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-width), (double)(layerHeight * (float)i - height / 2.0f), (double)(-width)).tex(0.0, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-width), (double)(layerHeight * (float)i - height / 2.0f), (double)width).tex(0.5, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-nextWidth), (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)nextWidth).tex(0.5, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)(-nextWidth), (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)(-nextWidth)).tex(0.0, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)width, (double)(layerHeight * (float)i - height / 2.0f), (double)(-width)).tex(0.0, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)width, (double)(layerHeight * (float)i - height / 2.0f), (double)width).tex(0.5, 0.0).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)nextWidth, (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)nextWidth).tex(0.5, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                    buffer.pos((double)nextWidth, (double)(layerHeight + layerHeight * (float)i - height / 2.0f), (double)(-nextWidth)).tex(0.0, 0.5).lightmap(lx, ly).color(1.0f, 1.0f, 1.0f, 0.65f).endVertex();
                }
                tess.draw();
                GlStateManager.popMatrix();
            }
            GlStateManager.enableCull();
            GlStateManager.enableLighting();
            GlStateManager.disableAlpha();
            GlStateManager.disableBlend();
            GlStateManager.popAttrib();
        }
    }

    private float getGrowthFactor(float capacityFactor, double emberCapacity) {
        return (float)(emberCapacity % (double)capacityFactor) / capacityFactor;
    }
}

