/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IBin;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageAshenAmuletFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCinderPlinth
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController,
IExtraCapabilityInformation {
    public static double EMBER_COST = ConfigMachine.CINDER_PLINTH.emberCost;
    public static int PROCESS_TIME = ConfigMachine.CINDER_PLINTH.processTime;
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    int progress = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityCinderPlinth.this.markDirty();
        }
    };
    Random random = new Random();
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityCinderPlinth() {
        this.capability.setEmberCapacity(4000.0);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.capability.writeToNBT(tag);
        tag.setInteger("progress", 0);
        tag.setTag("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.capability.readFromNBT(tag);
        this.progress = tag.getInteger("progress");
        this.inventory.deserializeNBT(tag.getCompoundTag("inventory"));
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 0, this.getUpdateTag());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.getNbtCompound());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void markDirty() {
        super.markDirty();
        Misc.syncTE(this);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        if (!heldItem.isEmpty()) {
            player.setHeldItem(hand, this.inventory.insertItem(0, heldItem, false));
            this.markDirty();
            return true;
        }
        if (!this.inventory.getStackInSlot(0).isEmpty()) {
            if (!this.getWorld().isRemote) {
                player.setHeldItem(hand, this.inventory.extractItem(0, this.inventory.getStackInSlot(0).getCount(), false));
                this.markDirty();
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.invalidate();
        Misc.spawnInventoryInWorld(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (IItemHandler)this.inventory);
        world.setTileEntity(pos, null);
    }

    public void update() {
        this.turnRate = 1;
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.world, this.pos, EnumFacing.VALUES);
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        if (this.getWorld().isRemote) {
            this.handleSound();
        }
        if (this.shouldWork()) {
            boolean cancel = UpgradeUtil.doWork(this, upgrades);
            if (!cancel) {
                ++this.progress;
                if (this.getWorld().isRemote) {
                    ParticleUtil.spawnParticleSmoke(this.getWorld(), (float)this.getPos().getX() + 0.5f, (float)this.getPos().getY() + 0.875f, (float)this.getPos().getZ() + 0.5f, 0.0125f * (this.random.nextFloat() - 0.5f), 0.025f * (this.random.nextFloat() + 1.0f), 0.0125f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 0.6f, 3.0f + this.random.nextFloat(), 48);
                }
                double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, upgrades);
                UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), upgrades);
                this.capability.removeAmount(emberCost, true);
                if (this.progress > UpgradeUtil.getWorkTime(this, PROCESS_TIME, upgrades)) {
                    this.progress = 0;
                    TileEntity tile = this.getWorld().getTileEntity(this.getPos().down());
                    ArrayList outputs = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemRegister.DUST_ASH, 1)});
                    UpgradeUtil.transformOutput((TileEntity)this, outputs, upgrades);
                    this.inventory.extractItem(0, 1, false);
                    for (ItemStack remainder : outputs) {
                        if (tile instanceof IBin) {
                            remainder = ((IBin)tile).getInventory().insertItem(0, remainder, false);
                        }
                        if (remainder.isEmpty() || this.getWorld().isRemote) continue;
                        this.getWorld().spawnEntity((Entity)new EntityItem(this.getWorld(), (double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.0, (double)this.getPos().getZ() + 0.5, remainder));
                    }
                    if (!this.getWorld().isRemote) {
                        AxisAlignedBB aabb = new AxisAlignedBB((double)this.pos.getX() + 0.3, (double)this.pos.getY() + 0.9, (double)this.pos.getZ() + 0.3, (double)this.pos.getX() + 0.7, (double)this.pos.getY() + 1.3, (double)this.pos.getZ() + 0.7);
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageAshenAmuletFX(aabb));
                    }
                }
                this.markDirty();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.markDirty();
        }
        this.angle += this.turnRate;
    }

    private boolean shouldWork() {
        return !this.inventory.getStackInSlot(0).isEmpty() && this.capability.getEmber() > 0.0;
    }

    @Override
    public void playSound(int id) {
        if (id == 1) {
            Embers.proxy.playMachineSound(this, 1, SoundManager.PLINTH_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.pos.getX() + 0.5f, (float)this.pos.getY() + 0.5f, (float)this.pos.getZ() + 0.5f);
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.shouldWork();
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", null));
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", I18n.format((String)"embers.tooltip.goggles.item.ash", (Object[])new Object[0])));
        }
    }
}

