/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.block.BlockBaseGauge;
import teamroots.embers.tileentity.ITileEntityBase;

public abstract class TileEntityBaseGauge
extends TileEntity
implements ITileEntityBase,
ITickable {
    int comparatorValue = 0;

    public int getComparatorValue() {
        return this.comparatorValue;
    }

    public void update() {
        int oldComparatorValue = this.comparatorValue;
        EnumFacing facing = this.getFacing();
        TileEntity tileEntity = this.world.getTileEntity(this.pos.offset(facing.getOpposite()));
        if (tileEntity != null) {
            this.comparatorValue = this.calculateComparatorValue(tileEntity, facing);
        }
        if (this.comparatorValue != oldComparatorValue) {
            this.world.updateComparatorOutputLevel(this.pos, this.world.getBlockState(this.pos).getBlock());
        }
    }

    private EnumFacing getFacing() {
        IBlockState state = this.world.getBlockState(this.pos);
        return (EnumFacing)state.getValue((IProperty)BlockBaseGauge.facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public abstract int calculateComparatorValue(TileEntity var1, EnumFacing var2);

    public abstract String getDialType();
}

