/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.particle;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import teamroots.embers.config.ConfigClient;
import teamroots.embers.particle.IEmberParticle;
import teamroots.embers.particle.ParticleSmoke;
import teamroots.embers.proxy.ClientProxy;

public class ParticleAsh
extends Particle
implements IEmberParticle {
    double width;
    double height;
    double depth;

    public ParticleAsh(World worldIn, double x1, double y1, double z1, double x2, double y2, double z2, float lifetime) {
        super(worldIn, x1, y1, z1, 0.0, 0.0, 0.0);
        this.width = x2 - x1;
        this.height = y2 - y1;
        this.depth = z2 - z1;
        this.particleMaxAge = (int)(lifetime * 0.5f);
        this.canCollide = ConfigClient.enableParticleCollisions;
    }

    public void onUpdate() {
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setExpired();
        }
        int particles = (int)Math.ceil(Math.sqrt(this.width * this.width + this.height * this.height + this.depth * this.depth));
        for (int i = 0; i < particles * 4; ++i) {
            double x = this.posX + this.width * this.rand.nextDouble();
            double y = this.posY + this.height * this.rand.nextDouble();
            double z = this.posZ + this.depth * this.rand.nextDouble();
            double speed = this.rand.nextDouble() * 0.1 + 0.1;
            float sizeSmall = this.rand.nextFloat() + 1.0f;
            float sizeBig = this.rand.nextFloat() * 2.0f + 2.0f;
            ClientProxy.particleRenderer.addParticle(new ParticleSmoke(this.world, x, y, z, 0.0, -speed, 0.0, 0.0f, 0.0f, 0.0f, 0.7f, sizeSmall, 20));
            ClientProxy.particleRenderer.addParticle(new ParticleSmoke(this.world, x, y, z, (this.rand.nextDouble() - 0.5) * 0.1, (this.rand.nextDouble() - 0.5) * 0.1, (this.rand.nextDouble() - 0.5) * 0.1, 0.0f, 0.0f, 0.0f, 0.2f, sizeBig, 40));
        }
    }

    public void renderParticle(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
    }

    @Override
    public boolean alive() {
        return this.particleAge < this.particleMaxAge;
    }

    @Override
    public boolean isAdditive() {
        return false;
    }

    @Override
    public boolean renderThroughBlocks() {
        return false;
    }
}

