/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.util.Misc;

public class ModelMagmaWormSegmentLarge
extends ModelBase {
    public static ModelMagmaWormSegmentLarge INSTANCE;
    ModelRenderer head1;
    ModelRenderer stonehead1;
    ModelRenderer stonehead2;
    ModelRenderer head2;
    ModelRenderer head3;
    ModelRenderer head4;
    ModelRenderer head5;
    ModelRenderer head6;
    ModelRenderer head7;
    ModelRenderer head8;
    ModelRenderer head9;
    ModelRenderer head10;
    ModelRenderer head11;
    ModelRenderer head12;
    ModelRenderer head13;

    public ModelMagmaWormSegmentLarge() {
        this.textureWidth = 128;
        this.textureHeight = 128;
        this.head1 = new ModelRenderer((ModelBase)this, 64, 0);
        this.head1.addBox(-6.0f, -6.0f, -6.0f, 12, 12, 12);
        this.head1.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.head1.setTextureSize(128, 128);
        this.head1.mirror = true;
        this.setRotation(this.head1, 0.0f, 0.0f, 0.0f);
        this.stonehead1 = new ModelRenderer((ModelBase)this, 16, 32);
        this.stonehead1.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6);
        this.stonehead1.setRotationPoint(0.0f, 0.0f, -1.0f);
        this.stonehead1.setTextureSize(128, 128);
        this.stonehead1.mirror = true;
        this.setRotation(this.stonehead1, 0.0f, 0.0f, 0.0f);
        this.stonehead2 = new ModelRenderer((ModelBase)this, 16, 32);
        this.stonehead2.addBox(-2.0f, -2.0f, -2.0f, 4, 4, 4);
        this.stonehead2.setRotationPoint(0.0f, 0.0f, 6.0f);
        this.stonehead2.setTextureSize(128, 128);
        this.stonehead2.mirror = true;
        this.setRotation(this.stonehead2, 0.0f, 0.0f, 0.0f);
        this.head2 = new ModelRenderer((ModelBase)this, 0, 64);
        this.head2.addBox(-5.0f, -5.0f, -5.0f, 10, 10, 10);
        this.head2.setRotationPoint(0.0f, 0.0f, 11.0f);
        this.head2.setTextureSize(128, 128);
        this.head2.mirror = true;
        this.setRotation(this.head2, 0.0f, 0.0f, 0.0f);
        this.head3 = new ModelRenderer((ModelBase)this, 0, 16);
        this.head3.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6);
        this.head3.setRotationPoint(0.0f, 0.0f, 19.0f);
        this.head3.setTextureSize(128, 128);
        this.head3.mirror = true;
        this.setRotation(this.head3, 0.0f, 0.0f, 0.0f);
        this.head4 = new ModelRenderer((ModelBase)this, 0, 64);
        this.head4.addBox(-5.0f, 0.0f, -5.0f, 10, 10, 10);
        this.head4.setRotationPoint(1.0f, -2.0f, -1.0f);
        this.head4.setTextureSize(128, 128);
        this.head4.mirror = true;
        this.setRotation(this.head4, 1.963495f, 0.7853982f, -0.5235988f);
        this.head5 = new ModelRenderer((ModelBase)this, 0, 64);
        this.head5.addBox(-5.0f, 0.0f, -5.0f, 10, 10, 10);
        this.head5.setRotationPoint(1.0f, 2.0f, -1.0f);
        this.head5.setTextureSize(128, 128);
        this.head5.mirror = true;
        this.setRotation(this.head5, 1.178097f, 0.3926991f, -0.5235988f);
        this.head6 = new ModelRenderer((ModelBase)this, 0, 64);
        this.head6.addBox(-5.0f, 0.0f, -5.0f, 10, 10, 10);
        this.head6.setRotationPoint(-1.0f, -2.0f, -1.0f);
        this.head6.setTextureSize(128, 128);
        this.head6.mirror = true;
        this.setRotation(this.head6, 1.963495f, -0.7853982f, 0.5235988f);
        this.head7 = new ModelRenderer((ModelBase)this, 0, 64);
        this.head7.addBox(-5.0f, 0.0f, -5.0f, 10, 10, 10);
        this.head7.setRotationPoint(-1.0f, 2.0f, -1.0f);
        this.head7.setTextureSize(128, 128);
        this.head7.mirror = true;
        this.setRotation(this.head7, 1.178097f, -0.3926991f, 0.5235988f);
        this.head8 = new ModelRenderer((ModelBase)this, 0, 16);
        this.head8.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6);
        this.head8.setRotationPoint(0.0f, -6.0f, -3.0f);
        this.head8.setTextureSize(128, 128);
        this.head8.mirror = true;
        this.setRotation(this.head8, 0.7853982f, 0.0f, 0.0f);
        this.head9 = new ModelRenderer((ModelBase)this, 0, 16);
        this.head9.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6);
        this.head9.setRotationPoint(0.0f, 6.0f, -3.0f);
        this.head9.setTextureSize(128, 128);
        this.head9.mirror = true;
        this.setRotation(this.head9, -0.7853982f, 0.0f, 0.0f);
        this.head10 = new ModelRenderer((ModelBase)this, 0, 0);
        this.head10.addBox(-4.0f, 0.0f, -4.0f, 8, 8, 8);
        this.head10.setRotationPoint(-1.0f, -2.0f, 7.0f);
        this.head10.setTextureSize(128, 128);
        this.head10.mirror = true;
        this.setRotation(this.head10, 1.963495f, -0.7853982f, 0.5235988f);
        this.head11 = new ModelRenderer((ModelBase)this, 0, 0);
        this.head11.addBox(-4.0f, 0.0f, -4.0f, 8, 8, 8);
        this.head11.setRotationPoint(1.0f, -2.0f, 7.0f);
        this.head11.setTextureSize(128, 128);
        this.head11.mirror = true;
        this.setRotation(this.head11, 1.963495f, 0.7853982f, -0.5235988f);
        this.head12 = new ModelRenderer((ModelBase)this, 0, 0);
        this.head12.addBox(-4.0f, 0.0f, -4.0f, 8, 8, 8);
        this.head12.setRotationPoint(1.0f, 2.386667f, 6.0f);
        this.head12.setTextureSize(128, 128);
        this.head12.mirror = true;
        this.setRotation(this.head12, 1.178097f, 0.3926991f, -0.5235988f);
        this.head13 = new ModelRenderer((ModelBase)this, 0, 0);
        this.head13.addBox(-4.0f, 0.0f, -4.0f, 8, 8, 8);
        this.head13.setRotationPoint(-1.0f, 2.386667f, 6.0f);
        this.head13.setTextureSize(128, 128);
        this.head13.mirror = true;
        this.setRotation(this.head13, 1.178097f, -0.3926991f, 0.5235988f);
    }

    public Vec3d getPosFromIndex(EntityMagmaWorm guardian, int index, float partialTicks) {
        return guardian.getSegmentPosition(index, partialTicks);
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, int index) {
        float scale = scaleFactor;
        super.render(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        GlStateManager.pushAttrib();
        EntityMagmaWorm guardian = (EntityMagmaWorm)entity;
        Vec3d basePos = guardian.getHeadPosition(ageInTicks - (float)((int)ageInTicks));
        float fade = guardian.getFade(ageInTicks - (float)((int)ageInTicks));
        Vec3d pos1 = this.getPosFromIndex(guardian, index, ageInTicks - (float)((int)ageInTicks));
        Vec3d pos2 = this.getPosFromIndex(guardian, index + 1, ageInTicks - (float)((int)ageInTicks));
        float yaw = Misc.yawDegreesBetweenPoints(pos2.x, pos1.y, pos1.z, pos1.x, pos2.y, pos2.z);
        float pitch = Misc.pitchDegreesBetweenPoints(pos2.x, pos1.y, pos1.z, pos1.x, pos2.y, pos2.z);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(-basePos.x + pos1.x), (double)(basePos.y - pos1.y), (double)(basePos.z - pos1.z));
        GlStateManager.rotate((float)(yaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f * fade));
        this.stonehead1.render(scale);
        this.stonehead2.render(scale);
        GlStateManager.enableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.disableLighting();
        float lavaFade = guardian.getSegmentFade(index) * fade;
        GlStateManager.color((float)(1.0f * lavaFade), (float)(1.0f * lavaFade), (float)(1.0f * lavaFade), (float)(0.75f * lavaFade));
        this.head1.render(scale);
        this.head2.render(scale);
        this.head3.render(scale);
        this.head4.render(scale);
        this.head5.render(scale);
        this.head6.render(scale);
        this.head7.render(scale);
        this.head8.render(scale);
        this.head9.render(scale);
        this.head10.render(scale);
        this.head11.render(scale);
        this.head12.render(scale);
        this.head13.render(scale);
        GlStateManager.enableLighting();
        GlStateManager.disableAlpha();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }
}

