/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.event.ItemVisualEvent;
import teamroots.embers.api.item.IProjectileWeapon;
import teamroots.embers.api.projectile.EffectArea;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.api.projectile.ProjectileFireball;
import teamroots.embers.config.ConfigTool;
import teamroots.embers.damage.DamageEmber;
import teamroots.embers.item.ItemBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.EmberInventoryUtil;
import teamroots.embers.util.Misc;

public class ItemCinderStaff
extends ItemBase
implements IProjectileWeapon {
    public static double EMBER_COST = ConfigTool.CINDER_STAFF.cost;
    public static int COOLDOWN = ConfigTool.CINDER_STAFF.cooldown;
    public static double MAX_CHARGE = ConfigTool.CINDER_STAFF.charge;
    public static float DAMAGE = ConfigTool.CINDER_STAFF.damage;
    public static float SIZE = ConfigTool.CINDER_STAFF.size;
    public static float AOE_SIZE = ConfigTool.CINDER_STAFF.aoe;
    public static int LIFETIME = ConfigTool.CINDER_STAFF.lifetime;
    public static boolean soundPlaying = false;

    public ItemCinderStaff() {
        super("staff_ember", true);
        this.setMaxStackSize(1);
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.isRemote) {
            double charge = Math.min(MAX_CHARGE, (double)(this.getMaxItemUseDuration(stack) - timeLeft)) / MAX_CHARGE;
            float spawnDistance = 2.0f;
            Vec3d eyesPos = entity.getPositionEyes(1.0f);
            RayTraceResult traceResult = this.rayTrace(world, (EntityPlayer)entity, false);
            if (traceResult != null && traceResult.typeOfHit == RayTraceResult.Type.BLOCK) {
                spawnDistance = (float)Math.min((double)spawnDistance, traceResult.hitVec.distanceTo(eyesPos));
            }
            Vec3d launchPos = eyesPos.add(entity.getLookVec().scale((double)spawnDistance));
            float damage = (float)Math.max(charge * (double)DAMAGE, 0.5);
            float size = (float)Math.max(charge * (double)SIZE, 0.5);
            float aoeSize = (float)charge * AOE_SIZE;
            int lifetime = charge * (double)DAMAGE >= 1.0 ? LIFETIME : 5;
            EffectArea effect = new EffectArea(new EffectDamage(damage, DamageEmber.EMBER_DAMAGE_SOURCE_FACTORY, 1, 1.0), aoeSize, false);
            ProjectileFireball fireball = new ProjectileFireball((Entity)entity, launchPos, entity.getLookVec().scale(0.85), size, lifetime, effect);
            EmberProjectileEvent event = new EmberProjectileEvent(entity, stack, charge, fireball);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                for (IProjectilePreset projectile : event.getProjectiles()) {
                    projectile.shoot(world);
                }
            }
            SoundEvent sound = charge * (double)DAMAGE >= 10.0 ? SoundManager.FIREBALL_BIG : (charge * (double)DAMAGE >= 1.0 ? SoundManager.FIREBALL : SoundManager.CINDER_STAFF_FAIL);
            world.playSound(null, launchPos.x, launchPos.y, launchPos.z, sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        entity.swingArm(entity.getActiveHand());
        stack.getTagCompound().setInteger("cooldown", COOLDOWN);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
            stack.getTagCompound().setInteger("cooldown", 0);
        } else if (stack.getTagCompound().getInteger("cooldown") > 0) {
            stack.getTagCompound().setInteger("cooldown", stack.getTagCompound().getInteger("cooldown") - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        double charge;
        if (stack.getTagCompound().getInteger("cooldown") > 0) {
            player.resetActiveHand();
        }
        boolean fullCharge = (charge = (double)Math.min(60, 72000 - count) / 60.0 * 15.0) >= 15.0;
        ItemVisualEvent event = new ItemVisualEvent(player, Misc.handToSlot(player.getActiveHand()), stack, new Color(255, 64, 16), (SoundEvent)(fullCharge ? SoundManager.CINDER_STAFF_LOOP : null), 1.0f, 1.0f, "charge");
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (player.world.isRemote) {
            if (event.hasSound()) {
                if (!soundPlaying) {
                    Embers.proxy.playItemSound(player, this, event.getSound(), SoundCategory.PLAYERS, true, event.getVolume(), event.getPitch());
                    soundPlaying = true;
                }
            } else {
                soundPlaying = false;
            }
        }
        if (event.hasParticles()) {
            Color color = event.getColor();
            float spawnDistance = 2.0f;
            Vec3d eyesPos = player.getPositionEyes(1.0f);
            RayTraceResult traceResult = this.rayTrace(player.world, (EntityPlayer)player, false);
            if (traceResult != null && traceResult.typeOfHit == RayTraceResult.Type.BLOCK) {
                spawnDistance = (float)Math.min((double)spawnDistance, traceResult.hitVec.distanceTo(eyesPos));
            }
            Vec3d launchPos = eyesPos.add(player.getLookVec().scale((double)spawnDistance));
            for (int i = 0; i < 4; ++i) {
                ParticleUtil.spawnParticleGlow(player.getEntityWorld(), (float)launchPos.x + (itemRand.nextFloat() * 0.1f - 0.05f), (float)launchPos.y + (itemRand.nextFloat() * 0.1f - 0.05f), (float)launchPos.z + (itemRand.nextFloat() * 0.1f - 0.05f), 0.0f, 0.0f, 0.0f, color.getRed(), color.getGreen(), color.getBlue(), (float)charge / 1.75f, 24);
            }
        }
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (EmberInventoryUtil.getEmberTotal(player) >= EMBER_COST && stack.getTagCompound().getInteger("cooldown") <= 0 || player.capabilities.isCreativeMode) {
            EmberInventoryUtil.removeEmber(player, EMBER_COST);
            player.setActiveHand(hand);
            if (world.isRemote) {
                Embers.proxy.playItemSound((EntityLivingBase)player, this, SoundManager.CINDER_STAFF_CHARGE, SoundCategory.PLAYERS, false, 1.0f, 1.0f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

