/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.heat;

import net.minecraft.nbt.NBTTagCompound;
import teamroots.embers.heat.IHeatCapability;

public class DefaultHeatCapability
implements IHeatCapability {
    private double heat = 0.0;
    private double capacity = 0.0;

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public double getHeatCapacity() {
        return this.capacity;
    }

    @Override
    public void setHeat(double value) {
        this.heat = value;
    }

    @Override
    public void setHeatCapacity(double value) {
        this.capacity = value;
    }

    @Override
    public double addAmount(double value, boolean doAdd) {
        if (this.heat + value > this.capacity) {
            double added = this.capacity - this.heat;
            if (doAdd) {
                this.heat = this.capacity;
            }
            return added;
        }
        if (doAdd) {
            this.heat += value;
        }
        return value;
    }

    @Override
    public double removeAmount(double value, boolean doRemove) {
        if (this.heat - value < 0.0) {
            double removed = this.heat;
            if (doRemove) {
                this.heat = 0.0;
            }
            return removed;
        }
        if (doRemove) {
            this.heat -= value;
        }
        return value;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.setDouble("embers:heat", this.heat);
        tag.setDouble("embers:heatCapacity", this.capacity);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("embers:heat")) {
            this.heat = tag.getDouble("embers:heat");
        }
        if (tag.hasKey("embers:heatCapacity")) {
            this.capacity = tag.getDouble("embers:heatCapacity");
        }
    }
}

