/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaProjectile;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.util.Bezier;

public class Pillars
extends MagmaWormPhase {
    private static final double RANGE_ATTACK = 72.0;
    List<Entity> targets = new ArrayList<Entity>();

    public Pillars(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        return 0.5;
    }

    @Override
    public void onStart(EntityMagmaWorm worm) {
        List<Entity> possibleTargets = worm.getAttackTargets(new AxisAlignedBB(worm.posX - 72.0, worm.posY - 72.0, worm.posZ - 72.0, worm.posX + 72.0, worm.posY + 72.0, worm.posZ + 72.0));
        if (!possibleTargets.isEmpty()) {
            Entity target;
            int i;
            int tries = 3;
            ArrayList<Vec3d> points = new ArrayList<Vec3d>();
            points.add(new Vec3d(worm.posX, worm.posY, worm.posZ));
            for (i = 0; i < 7; ++i) {
                target = possibleTargets.get(this.random.nextInt(possibleTargets.size()));
                this.targets.add(target);
            }
            for (i = 0; i < tries; ++i) {
                target = possibleTargets.get(this.random.nextInt(possibleTargets.size()));
                Vec3d lastPos = (Vec3d)points.get(points.size() - 1);
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double x = target.posX;
                double z = target.posZ;
                double dx = Math.sin(angle) * 5.0;
                double dz = Math.cos(angle) * 5.0;
                double height = MagmaWormPhase.getHeight(worm.world, lastPos.x + dx, lastPos.z + dz);
                points.add(new Vec3d(lastPos.x + dx, height + 20.0 + this.random.nextDouble() * 10.0, lastPos.z + dz));
                points.add(new Vec3d(x, height + 5.0 + this.random.nextDouble() * 10.0, z));
            }
            worm.setCurrentSpline(new Bezier(points), 10, 0.3);
        }
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        if (!this.targets.isEmpty() && worm.ticksExisted % 10 == 5) {
            Entity target = this.targets.get(this.random.nextInt(this.targets.size()));
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double distance = this.random.nextDouble() * 12.0 + 0.0;
            double dx = Math.sin(angle) * distance;
            double dz = Math.cos(angle) * distance;
            double height = MagmaWormPhase.getHeight(worm.world, target.posX + dx, target.posZ + dz);
            Vec3d location = new Vec3d(target.posX + dx, height + 0.5, target.posZ + dz);
            EntityMagmaProjectile projectile = new EntityMagmaProjectile(worm.world, worm);
            projectile.setPosition(location.x, location.y, location.z);
            projectile.makePillar(12.0f, (int)distance * 5);
            worm.world.spawnEntity((Entity)projectile);
        }
    }

    @Override
    public void onUndig(EntityMagmaWorm worm) {
        Vec3d location = new Vec3d(worm.posX, worm.posY + 2.0, worm.posZ);
        Pillars.splashMagma(worm, location, 12);
    }
}

