/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.util.Bezier;

public class Lunge
extends MagmaWormPhase {
    private static final double RANGE_ATTACK = 36.0;
    private int digCooldown;
    private int undigCooldown;
    private Entity entity;
    private int repeat;
    private double velocity = 0.25;

    public Lunge(MagmaWormPhase.PhaseSupplier supplier, int repeat) {
        super(supplier);
        this.repeat = repeat;
    }

    public Lunge(MagmaWormPhase.PhaseSupplier supplier, Entity entity, int repeat) {
        super(supplier);
        this.entity = entity;
        this.repeat = repeat;
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        if (worm.isDigging()) {
            return 0.5;
        }
        return this.velocity;
    }

    @Override
    public MagmaWormPhase pickFollowup(Random random) {
        if (this.repeat > 0) {
            return new Lunge(this.supplier, this.entity, this.repeat - 1);
        }
        return super.pickFollowup(random);
    }

    @Override
    public void onStart(EntityMagmaWorm worm) {
        List<Entity> targets = worm.getAttackTargets(new AxisAlignedBB(worm.posX - 36.0, worm.posY - 36.0, worm.posZ - 36.0, worm.posX + 36.0, worm.posY + 36.0, worm.posZ + 36.0));
        if (!targets.isEmpty()) {
            Entity target = targets.get(this.random.nextInt(targets.size()));
            ArrayList<Vec3d> points = new ArrayList<Vec3d>();
            points.add(new Vec3d(worm.posX, worm.posY, worm.posZ));
            points.add(new Vec3d(worm.posX, MagmaWormPhase.getHeight(worm.world, worm.posX, worm.posZ) + 3.0, worm.posZ));
            Vec3d targetPos = new Vec3d(target.posX, target.posY + (double)(target.height / 2.0f), target.posZ);
            points.add(targetPos);
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double dx = Math.sin(angle) * 10.0;
            double dz = Math.cos(angle) * 10.0;
            double height = MagmaWormPhase.getHeight(worm.world, targetPos.x + dx, targetPos.z + dz);
            points.add(new Vec3d(targetPos.x + dx, height - 5.0, targetPos.z + dz));
            worm.setCurrentSpline(new Bezier(points), 10, 0.3);
        }
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        --this.digCooldown;
        --this.undigCooldown;
        this.velocity = Math.min(2.0, this.velocity + 0.01);
    }

    @Override
    public void onDig(EntityMagmaWorm worm) {
        if (this.digCooldown > 0) {
            return;
        }
        Vec3d location = new Vec3d(worm.posX, worm.posY + 2.0, worm.posZ);
        Lunge.splashMagma(worm, location, 6);
        this.digCooldown = 30;
    }

    @Override
    public void onUndig(EntityMagmaWorm worm) {
        if (this.undigCooldown > 0) {
            return;
        }
        Vec3d location = new Vec3d(worm.posX, worm.posY + 2.0, worm.posZ);
        Lunge.splashMagma(worm, location, 6);
        this.undigCooldown = 30;
    }
}

