/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSparkleFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.Misc;

public class EntityEmberPacket
extends Entity {
    BlockPos pos = new BlockPos(0, 0, 0);
    public BlockPos dest = new BlockPos(0, 0, 0);
    public double value = 0.0;
    public int lifetime = 80;
    public float hue = Misc.random.nextFloat() * 360.0f;
    public boolean dead = false;

    public EntityEmberPacket(World worldIn) {
        super(worldIn);
        this.setSize(0.0f, 0.0f);
        this.setInvisible(true);
    }

    public void initCustom(BlockPos pos, BlockPos dest, double vx, double vy, double vz, double value) {
        this.posX = (double)pos.getX() + 0.5;
        this.posY = (double)pos.getY() + 0.5;
        this.posZ = (double)pos.getZ() + 0.5;
        this.motionX = vx;
        this.motionY = vy;
        this.motionZ = vz;
        this.dest = dest;
        this.pos = pos;
        this.value = value;
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound compound) {
        if (compound.hasKey("destX")) {
            this.dest = new BlockPos(compound.getInteger("destX"), compound.getInteger("destY"), compound.getInteger("destZ"));
            this.setPosition(compound.getDouble("x"), compound.getDouble("y"), compound.getDouble("z"));
            this.value = compound.getDouble("value");
            this.motionX = compound.getDouble("vx");
            this.motionY = compound.getDouble("vy");
            this.motionZ = compound.getDouble("vz");
            this.dead = compound.getBoolean("dead");
        }
    }

    protected void writeEntityToNBT(NBTTagCompound compound) {
        if (this.dest != null) {
            compound.setInteger("destX", this.dest.getX());
            compound.setInteger("destY", this.dest.getY());
            compound.setInteger("destZ", this.dest.getZ());
        }
        compound.setDouble("x", this.posX);
        compound.setDouble("y", this.posY);
        compound.setDouble("z", this.posZ);
        compound.setDouble("value", this.value);
        compound.setDouble("vx", this.motionX);
        compound.setDouble("vy", this.motionY);
        compound.setDouble("vz", this.motionZ);
        compound.setBoolean("dead", this.dead);
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.lifetime == 79 && !this.getEntityWorld().isRemote) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX(this.posX, this.posY, this.posZ, false));
        }
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.dead = true;
            this.getEntityWorld().removeEntity((Entity)this);
        }
        if (!this.dead) {
            if (this.dest.getX() != 0 || this.dest.getY() != 0 || this.dest.getZ() != 0) {
                double targetX = (double)this.dest.getX() + 0.5;
                double targetY = (double)this.dest.getY() + 0.5;
                double targetZ = (double)this.dest.getZ() + 0.5;
                Vec3d targetVector = new Vec3d(targetX - this.posX, targetY - this.posY, targetZ - this.posZ);
                double length = targetVector.length();
                targetVector = targetVector.scale(0.3 / length);
                double weight = 0.0;
                if (length <= 3.0) {
                    weight = 0.9 * ((3.0 - length) / 3.0);
                }
                this.motionX = (0.9 - weight) * this.motionX + (0.1 + weight) * targetVector.x;
                this.motionY = (0.9 - weight) * this.motionY + (0.1 + weight) * targetVector.y;
                this.motionZ = (0.9 - weight) * this.motionZ + (0.1 + weight) * targetVector.z;
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            IBlockState state = this.getEntityWorld().getBlockState(this.getPosition());
            TileEntity tile = this.getEntityWorld().getTileEntity(this.getPosition());
            BlockPos pos = this.getPosition();
            if (this.posX > (double)pos.getX() + 0.25 && this.posX < (double)pos.getX() + 0.75 && this.posY > (double)pos.getY() + 0.25 && this.posY < (double)pos.getY() + 0.75 && this.posZ > (double)pos.getZ() + 0.25 && this.posZ < (double)pos.getZ() + 0.75) {
                this.affectTileEntity(state, tile);
            }
            if (this.getEntityWorld().isRemote) {
                double deltaX = this.posX - this.prevPosX;
                double deltaY = this.posY - this.prevPosY;
                double deltaZ = this.posZ - this.prevPosZ;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
                for (double i = 0.0; i < dist; i += 1.0) {
                    double coeff = i / dist;
                    ParticleUtil.spawnParticleGlow(this.getEntityWorld(), (float)(this.prevPosX + deltaX * coeff), (float)(this.prevPosY + deltaY * coeff), (float)(this.prevPosZ + deltaZ * coeff), 0.0125f * (this.rand.nextFloat() - 0.5f), 0.0125f * (this.rand.nextFloat() - 0.5f), 0.0125f * (this.rand.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 2.0f, 12);
                }
            }
        }
    }

    public void affectTileEntity(IBlockState state, TileEntity tile) {
        if (tile instanceof IEmberPacketReceiver && ((IEmberPacketReceiver)tile).onReceive(this) && tile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)tile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            assert (capability != null);
            if (!this.getEntityWorld().isRemote) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSparkleFX(this.posX, this.posY, this.posZ, capability.getEmber() + this.value > capability.getEmberCapacity()));
            }
            capability.addAmount(this.value, true);
            tile.markDirty();
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.lifetime = 20;
            this.dead = true;
            this.getEntityWorld().removeEntity((Entity)this);
            this.world.playSound(null, this.posX, this.posY, this.posZ, this.value >= 100.0 ? SoundManager.EMBER_RECEIVE_BIG : SoundManager.EMBER_RECEIVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

