/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.thaumicperiphery;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.config.ConfigCompat;
import teamroots.embers.util.EmberInventoryUtil;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ItemFocus;
import thaumicperiphery.items.ItemCasterEmber;

public class EmberCaster
extends ItemCasterEmber {
    DecimalFormat formatter = new DecimalFormat("#######.#");

    public boolean consumeVis(ItemStack is, EntityPlayer player, float amount, boolean crafting, boolean sim) {
        double cost = amount * this.getConsumptionModifier(is, player, crafting);
        if (EmberInventoryUtil.getEmberTotal(player) < cost) {
            return false;
        }
        if (!sim) {
            EmberInventoryUtil.removeEmber(player, cost);
        }
        return true;
    }

    public float getConsumptionModifier(ItemStack is, EntityPlayer player, boolean crafting) {
        double consumptionModifier = 1.0 - (double)CasterManager.getTotalVisDiscount((EntityPlayer)player);
        return (float)(Math.max(consumptionModifier, 0.1) * ConfigCompat.THAUMCRAFT.emberMultiplier);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemFocus focus;
        if (stack.hasTagCompound()) {
            double amt;
            String text = "";
            ItemStack focus2 = this.getFocusStack(stack);
            if (focus2 != null && !focus2.isEmpty() && (amt = (double)(((ItemFocus)focus2.getItem()).getVisCost(focus2) * this.getConsumptionModifier(stack, null, false))) > 0.0) {
                text = String.format("%s%s %s", TextFormatting.RESET, this.formatter.format(amt), I18n.format((String)"item.Focus.cost_ember", (Object[])new Object[0]));
            }
            tooltip.add(String.format("%s%s%s %s", TextFormatting.ITALIC, TextFormatting.RED, I18n.format((String)"thaumicperiphery.ember.cost", (Object[])new Object[0]), text));
        }
        if ((focus = this.getFocus(stack)) != null) {
            ItemStack focusStack = this.getFocusStack(stack);
            tooltip.add(String.format("%s%s%s%s", TextFormatting.BOLD, TextFormatting.ITALIC, TextFormatting.GREEN, focus.getItemStackDisplayName(focusStack)));
            focus.addFocusInformation(focusStack, worldIn, tooltip, flagIn);
        }
    }
}

