/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.item.block.ItemBlockTank;
import teamroots.embers.tileentity.TileEntityTank;

public class BlockTank
extends BlockTEBase {
    public static AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static AxisAlignedBB AABB_SIDE_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    public static AxisAlignedBB AABB_SIDE_EAST = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static AxisAlignedBB AABB_SIDE_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    public static AxisAlignedBB AABB_SIDE_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);

    public BlockTank(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
        this.itemBlock = (Item)new ItemBlockTank(this).setRegistryName(this.getRegistryName());
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, player, stack);
        if (stack.hasTagCompound()) {
            TileEntityTank tile = (TileEntityTank)this.createNewTileEntity(world, this.getMetaFromState(state));
            world.setTileEntity(pos, (TileEntity)tile);
            tile.getTank().readFromNBT(stack.getTagCompound());
            tile.markDirty();
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        return items;
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        BlockTank.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BASE);
        BlockTank.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_WEST);
        BlockTank.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_NORTH);
        BlockTank.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_EAST);
        BlockTank.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_SIDE_SOUTH);
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityTank();
    }
}

