/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityPumpBottom;
import teamroots.embers.tileentity.TileEntityPumpTop;
import teamroots.embers.util.Misc;

public class BlockPump
extends BlockTEBase {
    public static final PropertyBool isTop = PropertyBool.create((String)"top");
    public static final PropertyDirection facing = PropertyDirection.create((String)"facing");

    public BlockPump(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{isTop, facing});
    }

    public int getMetaFromState(IBlockState state) {
        boolean top = (Boolean)state.getValue((IProperty)isTop);
        return (top ? 1 : 0) * 6 + ((EnumFacing)state.getValue((IProperty)facing)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)EnumFacing.byIndex((int)(meta % 6))).withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(meta >= 6));
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IBlockState state;
        if (!world.isRemote) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (this.getMetaFromState(state = world.getBlockState(pos)) < 6) {
            world.setBlockToAir(pos.up());
        } else {
            world.setBlockToAir(pos.down());
        }
        ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, state, null);
        world.setBlockToAir(pos);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (this.getMetaFromState(state) < 6) {
            world.setBlockState(pos.up(), this.getDefaultState().withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)facing, state.getValue((IProperty)facing)));
        } else {
            world.setBlockState(pos.down(), this.getDefaultState().withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)facing, state.getValue((IProperty)facing)));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)facing, (Comparable)Misc.getOppositeFace(placer.getHorizontalFacing())).withProperty((IProperty)isTop, (Comparable)Boolean.valueOf(false));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((((Boolean)state.getValue((IProperty)isTop)).booleanValue() && world.getBlockState(pos.down()).getBlock() == this || !((Boolean)state.getValue((IProperty)isTop)).booleanValue() && world.getBlockState(pos.up()).getBlock() == this) && !world.isRemote && !player.capabilities.isCreativeMode) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (this.getMetaFromState(state) < 6) {
            world.setBlockToAir(pos.up());
        } else {
            world.setBlockToAir(pos.down());
        }
        ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, state, player);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return world.getBlockState(pos.up()) == Blocks.AIR.getDefaultState();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        if (meta >= 6) {
            return new TileEntityPumpTop();
        }
        return new TileEntityPumpBottom();
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((ITileEntityBase)world.getTileEntity(pos)).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }
}

