/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import teamroots.embers.block.BlockBaseGauge;
import teamroots.embers.tileentity.TileEntityFluidGauge;

public class BlockFluidGauge
extends BlockBaseGauge {
    public static final String DIAL_TYPE = "fluid";

    public BlockFluidGauge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    @Override
    protected void getTEData(EnumFacing facing, ArrayList<String> text, TileEntity tileEntity) {
        IFluidHandler handler;
        if (tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) && (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) != null) {
            for (IFluidTankProperties property : handler.getTankProperties()) {
                FluidStack contents = property.getContents();
                int capacity = property.getCapacity();
                text.add(BlockFluidGauge.formatFluidStack(contents, capacity));
            }
        }
    }

    public static String formatFluidStack(FluidStack contents, int capacity) {
        if (contents != null) {
            return I18n.format((String)"embers.tooltip.fluiddial.fluid", (Object[])new Object[]{contents.getFluid().getLocalizedName(contents), contents.amount, capacity});
        }
        return I18n.format((String)"embers.tooltip.fluiddial.nofluid", (Object[])new Object[]{capacity});
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidGauge();
    }
}

