/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.register.BlockRegister;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityCombustor;

public class BlockCombustor
extends BlockTEBase {
    public static AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
    public static final PropertyInteger type = PropertyInteger.create((String)"type", (int)0, (int)5);

    public BlockCombustor(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)state.getValue((IProperty)type) == 0) {
            return AABB_BASE;
        }
        return AABB_TOP;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        BlockPos offPos;
        if ((Integer)state.getValue((IProperty)type) == 1) {
            if (world.getBlockState(fromPos).getBlock() == BlockRegister.REACTOR) {
                if (fromPos.compareTo((Vec3i)pos.offset(EnumFacing.NORTH)) == 0) {
                    world.setBlockState(pos, this.getStateFromMeta(2));
                    world.notifyBlockUpdate(pos, state, this.getStateFromMeta(2), 8);
                }
                if (fromPos.compareTo((Vec3i)pos.offset(EnumFacing.EAST)) == 0) {
                    world.setBlockState(pos, this.getStateFromMeta(3));
                    world.notifyBlockUpdate(pos, state, this.getStateFromMeta(3), 8);
                }
                if (fromPos.compareTo((Vec3i)pos.offset(EnumFacing.SOUTH)) == 0) {
                    world.setBlockState(pos, this.getStateFromMeta(4));
                    world.notifyBlockUpdate(pos, state, this.getStateFromMeta(4), 8);
                }
                if (fromPos.compareTo((Vec3i)pos.offset(EnumFacing.WEST)) == 0) {
                    world.setBlockState(pos, this.getStateFromMeta(5));
                    world.notifyBlockUpdate(pos, state, this.getStateFromMeta(5), 8);
                }
            }
        } else if (this.getFacingFromMeta((Integer)state.getValue((IProperty)type)) != EnumFacing.DOWN && (offPos = pos.offset(this.getFacingFromMeta((Integer)state.getValue((IProperty)type)))).compareTo((Vec3i)fromPos) == 0 && world.getBlockState(offPos).getBlock() != BlockRegister.REACTOR) {
            if (world.getBlockState(pos.offset(EnumFacing.NORTH)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos, this.getStateFromMeta(2));
                world.notifyBlockUpdate(pos, state, this.getStateFromMeta(2), 8);
            } else if (world.getBlockState(pos.offset(EnumFacing.EAST)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos, this.getStateFromMeta(3));
                world.notifyBlockUpdate(pos, state, this.getStateFromMeta(3), 8);
            } else if (world.getBlockState(pos.offset(EnumFacing.SOUTH)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos, this.getStateFromMeta(4));
                world.notifyBlockUpdate(pos, state, this.getStateFromMeta(4), 8);
            } else if (world.getBlockState(pos.offset(EnumFacing.WEST)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos, this.getStateFromMeta(5));
                world.notifyBlockUpdate(pos, state, this.getStateFromMeta(5), 8);
            } else {
                world.setBlockState(pos, this.getStateFromMeta(1));
                world.notifyBlockUpdate(pos, state, this.getStateFromMeta(1), 8);
            }
        }
    }

    public EnumFacing getFacingFromMeta(int meta) {
        if (meta == 2) {
            return EnumFacing.NORTH;
        }
        if (meta == 3) {
            return EnumFacing.EAST;
        }
        if (meta == 4) {
            return EnumFacing.SOUTH;
        }
        if (meta == 5) {
            return EnumFacing.WEST;
        }
        return EnumFacing.DOWN;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)type, (Comparable)Integer.valueOf(0));
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{type});
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)type);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)type, (Comparable)Integer.valueOf(meta));
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (this.getMetaFromState(state) == 0) {
            if (world.getBlockState(pos.up().offset(EnumFacing.NORTH)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos.up(), this.getStateFromMeta(2));
                world.notifyBlockUpdate(pos.up(), state, this.getStateFromMeta(2), 8);
            } else if (world.getBlockState(pos.up().offset(EnumFacing.EAST)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos.up(), this.getStateFromMeta(3));
                world.notifyBlockUpdate(pos.up(), state, this.getStateFromMeta(3), 8);
            } else if (world.getBlockState(pos.up().offset(EnumFacing.SOUTH)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos.up(), this.getStateFromMeta(4));
                world.notifyBlockUpdate(pos.up(), state, this.getStateFromMeta(4), 8);
            } else if (world.getBlockState(pos.up().offset(EnumFacing.WEST)).getBlock() == BlockRegister.REACTOR) {
                world.setBlockState(pos.up(), this.getStateFromMeta(5));
                world.notifyBlockUpdate(pos.up(), state, this.getStateFromMeta(5), 8);
            } else {
                world.setBlockState(pos.up(), this.getStateFromMeta(1));
                world.notifyBlockUpdate(pos.up(), state, this.getStateFromMeta(1), 8);
            }
        } else {
            world.setBlockState(pos.down(), this.getStateFromMeta(0));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Integer)state.getValue((IProperty)type) != 0 && world.getBlockState(pos.down()).getBlock() == this || (Integer)state.getValue((IProperty)type) == 0 && world.getBlockState(pos.up()).getBlock() == this) && !world.isRemote && !player.capabilities.isCreativeMode) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (this.getMetaFromState(state) == 0) {
            world.setBlockToAir(pos.up());
            ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, state, player);
        } else {
            world.setBlockToAir(pos.down());
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        IBlockState state;
        if (!world.isRemote) {
            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        if (this.getMetaFromState(state = world.getBlockState(pos)) == 0) {
            world.setBlockToAir(pos.up());
            ((ITileEntityBase)world.getTileEntity(pos)).breakBlock(world, pos, state, null);
        } else {
            world.setBlockToAir(pos.down());
        }
        world.setBlockToAir(pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return world.getBlockState(pos.up()) == Blocks.AIR.getDefaultState();
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        if (meta == 0) {
            return new TileEntityCombustor();
        }
        return null;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((Integer)state.getValue((IProperty)type) == 0) {
            return ((ITileEntityBase)world.getTileEntity(pos)).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }
}

