/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.block.BlockBase;
import teamroots.embers.config.ConfigMob;
import teamroots.embers.entity.EntityAncientGolem;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.register.BlockRegister;

public class BlockArchaicLight
extends BlockBase {
    public BlockArchaicLight(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
        this.needsRandomTick = true;
    }

    public int tickRate(World world) {
        return 1;
    }

    public boolean requiresUpdates() {
        return true;
    }

    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random random) {
        for (int i = 0; i < 12; ++i) {
            int chance = random.nextInt(3);
            if (chance == 0) {
                ParticleUtil.spawnParticleGlow(world, (float)pos.getX() - 0.03125f + 1.0625f * (float)random.nextInt(2), (float)pos.getY() + 0.125f + 0.75f * random.nextFloat(), (float)pos.getZ() + 0.125f + 0.75f * random.nextFloat(), (random.nextFloat() - 0.5f) * 0.003f, random.nextFloat() * 0.003f, (random.nextFloat() - 0.5f) * 0.003f, 255.0f, 64.0f, 16.0f, 2.5f, 120);
            }
            if (chance == 1) {
                ParticleUtil.spawnParticleGlow(world, (float)pos.getX() + 0.125f + 0.75f * random.nextFloat(), (float)pos.getY() - 0.03125f + 1.0625f * (float)random.nextInt(2), (float)pos.getZ() + 0.125f + 0.75f * random.nextFloat(), (random.nextFloat() - 0.5f) * 0.003f, random.nextFloat() * 0.003f, (random.nextFloat() - 0.5f) * 0.003f, 255.0f, 64.0f, 16.0f, 2.5f, 120);
            }
            if (chance != 2) continue;
            ParticleUtil.spawnParticleGlow(world, (float)pos.getX() + 0.125f + 0.75f * random.nextFloat(), (float)pos.getY() + 0.125f + 0.75f * random.nextFloat(), (float)pos.getZ() - 0.03125f + 1.0625f * (float)random.nextInt(2), (random.nextFloat() - 0.5f) * 0.003f, random.nextFloat() * 0.003f, (random.nextFloat() - 0.5f) * 0.003f, 255.0f, 64.0f, 16.0f, 2.5f, 120);
        }
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (!ConfigMob.EMBER_GOLEM.enableBuilding) {
            return;
        }
        if (world.getBlockState(pos.down()).getBlock() == BlockRegister.ARCHAIC_BRICKS && world.getBlockState(pos.down(2)).getBlock() == BlockRegister.ARCHAIC_BRICKS) {
            if (!world.isRemote) {
                EntityAncientGolem golem = new EntityAncientGolem(world);
                golem.onInitialSpawn(world.getDifficultyForLocation(pos), null);
                golem.setPosition((double)pos.getX() + 0.5, (double)pos.getY() - 1.0, (double)pos.getZ() + 0.5);
                world.spawnEntity((Entity)golem);
            }
            world.destroyBlock(pos, false);
            world.destroyBlock(pos.down(), false);
            world.destroyBlock(pos.down(2), false);
        }
    }
}

