/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.filter;

import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.api.filter.EnumFilterSetting;
import teamroots.embers.api.filter.IFilter;
import teamroots.embers.api.filter.IFilterComparator;
import teamroots.embers.util.FilterUtil;

public class FilterSieve
implements IFilter {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("embers", "sieve");
    private ItemStack stack1;
    private ItemStack stack2;
    private int offset;
    private EnumFilterSetting setting;
    private boolean inverted;
    private IFilterComparator comparator;

    public FilterSieve(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public FilterSieve(ItemStack stack1, ItemStack stack2, int offset, EnumFilterSetting setting, boolean inverted) {
        this.stack1 = stack1;
        this.stack2 = stack2;
        this.offset = offset;
        this.setting = setting;
        this.inverted = inverted;
        this.findComparator();
    }

    private void findComparator() {
        if (this.stack1.isEmpty() && this.stack2.isEmpty()) {
            this.comparator = FilterUtil.ANY;
        } else {
            List<IFilterComparator> comparators = FilterUtil.getComparators(this.stack1, this.stack2);
            this.comparator = comparators.get(this.offset % comparators.size());
        }
    }

    @Override
    public ResourceLocation getType() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return this.comparator.isBetween(this.stack1, this.stack2, stack, this.setting) != this.inverted;
    }

    @Override
    public String formatFilter() {
        if (this.comparator == null) {
            return "INVALID COMPARATOR";
        }
        return this.comparator.format(this.stack1, this.stack2, this.setting, this.inverted);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setString("type", this.getType().toString());
        tag.setTag("stack1", (NBTBase)this.stack1.serializeNBT());
        tag.setTag("stack2", (NBTBase)this.stack2.serializeNBT());
        tag.setInteger("offset", this.offset);
        tag.setInteger("setting", this.setting.ordinal());
        tag.setBoolean("inverted", this.inverted);
        tag.setString("comparator", this.comparator.getName());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.stack1 = new ItemStack(tag.getCompoundTag("stack1"));
        this.stack2 = new ItemStack(tag.getCompoundTag("stack2"));
        this.offset = tag.getInteger("offset");
        this.setting = EnumFilterSetting.values()[tag.getInteger("setting")];
        this.inverted = tag.getBoolean("invert");
        if (tag.hasKey("comparator")) {
            this.comparator = FilterUtil.getComparator(tag.getString("comparator"));
        } else {
            this.findComparator();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterSieve) {
            return this.equals((FilterSieve)obj);
        }
        return super.equals(obj);
    }

    private boolean equals(FilterSieve other) {
        return Objects.equals(this.comparator, other.comparator) && Objects.equals(this.inverted, other.inverted) && Objects.equals((Object)this.setting, (Object)other.setting) && ItemStack.areItemStacksEqual((ItemStack)this.stack1, (ItemStack)other.stack1) && ItemStack.areItemStacksEqual((ItemStack)this.stack2, (ItemStack)other.stack2);
    }
}

