/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.lwjgl.opengl.GL11;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.block.IDial;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.item.IEmberChargedTool;
import teamroots.embers.api.item.IInflictorGem;
import teamroots.embers.api.item.IInflictorGemHolder;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.compat.Util;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.item.ItemEmberGauge;
import teamroots.embers.item.ItemGrandhammer;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageEmberGenOffset;
import teamroots.embers.network.message.MessageTyrfingBurstFX;
import teamroots.embers.proxy.ClientProxy;
import teamroots.embers.register.DamageSourceRegister;
import teamroots.embers.register.FluidRegister;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.tileentity.ITileEntitySpecialRendererLater;
import teamroots.embers.tileentity.TileEntityExplosionPedestal;
import teamroots.embers.tileentity.TileEntityMechAccessor;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.world.EmberWorldData;

public class EventManager {
    double gaugeAngle = 0.0;
    public static boolean hasRenderedParticles = false;
    Random random = new Random();
    public static float emberEyeView = 0.0f;
    public static ResearchBase lastResearch = null;
    public static float frameTime = 0.0f;
    public static float frameCounter = 0.0f;
    public static long prevTime = 0L;
    public static EnumHand lastHand = EnumHand.MAIN_HAND;
    public static float starlightRed = 255.0f;
    public static float starlightGreen = 32.0f;
    public static float starlightBlue = 255.0f;
    public static float tickCounter = 0.0f;
    public static double currentEmber = 0.0;
    public static boolean allowPlayerRenderEvent = true;
    public static int ticks = 0;
    public static float prevCooledStrength = 0.0f;
    public static boolean acceptUpdates = true;
    public static WeakHashMap<World, ExplosionCharmWorldInfo> explosionCharmData = new WeakHashMap();
    static EntityPlayer clientPlayer = null;
    private static final ThreadLocal<Boolean> captureDrops = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<NonNullList<ItemStack>> capturedDrops = ThreadLocal.withInitial(NonNullList::create);
    static HashSet<String> removedItems = Sets.newHashSet((Object[])new String[]{"embers:advanced_edge", "embers:inferno_forge_edge", "embers:mech_edge", "embers:glow", "embers:structure_marker"});

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        TileEntity tile;
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        ExplosionCharmWorldInfo data = explosionCharmData.get(world);
        if (data == null) {
            return;
        }
        BlockPos charmPos = data.getClosestExplosionCharm(world, new BlockPos(explosion.getPosition()), 8);
        if (charmPos != null && (tile = world.getTileEntity(charmPos)) instanceof TileEntityExplosionPedestal) {
            ((TileEntityExplosionPedestal)tile).absorb(explosion);
            event.setCanceled(true);
        }
    }

    public static void putExplosionCharm(World world, BlockPos pos) {
        if (!explosionCharmData.containsKey(world)) {
            explosionCharmData.put(world, new ExplosionCharmWorldInfo());
        }
        ExplosionCharmWorldInfo data = explosionCharmData.get(world);
        data.put(pos);
    }

    public static NonNullList<ItemStack> captureDrops(boolean start) {
        if (start) {
            captureDrops.set(true);
            capturedDrops.get().clear();
            return NonNullList.create();
        }
        captureDrops.set(false);
        return capturedDrops.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        if (world.isRemote) {
            return;
        }
        float chance = event.getDropChance();
        if (captureDrops.get().booleanValue()) {
            NonNullList<ItemStack> stacks = capturedDrops.get();
            for (ItemStack stack : event.getDrops()) {
                if (stack == null || stack.isEmpty() || !(world.rand.nextFloat() <= chance)) continue;
                stacks.add((Object)stack);
            }
            event.getDrops().clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        ResourceLocation particleGlow = new ResourceLocation("embers:entity/particle_mote");
        event.getMap().registerSprite(particleGlow);
        ResourceLocation particleSparkle = new ResourceLocation("embers:entity/particle_star");
        event.getMap().registerSprite(particleSparkle);
        ResourceLocation particleSmoke = new ResourceLocation("embers:entity/particle_smoke");
        event.getMap().registerSprite(particleSmoke);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_ALCHEMICAL_REDSTONE);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_LEAD);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_TIN);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_ALUMINUM);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_BRONZE);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_COPPER);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_DAWNSTONE);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_ELECTRUM);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_GOLD);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_IRON);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_NICKEL);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_MOLTEN_SILVER);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_STEAM);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_CRUDE_OIL);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_OIL);
        this.stitchFluid(event.getMap(), FluidRegister.FLUID_GAS);
    }

    @SideOnly(value=Side.CLIENT)
    private void stitchFluid(TextureMap map, Fluid fluid) {
        map.registerSprite(fluid.getStill());
        map.registerSprite(fluid.getFlowing());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.world.provider.getDimensionType() == DimensionType.OVERWORLD) {
            boolean changed = false;
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offX;
                EmberWorldData.get(event.world).markDirty();
                changed = true;
            }
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offZ;
                EmberWorldData.get(event.world).markDirty();
                changed = true;
            }
            if (changed) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberGenOffset(EmberGenUtil.offX, EmberGenUtil.offZ));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        EntityPlayer damager;
        ItemStack s2;
        EntityLivingBase entityLiving = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entityLiving instanceof EntityPlayer) {
            this.attuneInflictorGem(entityLiving, source, entityLiving.getHeldItemMainhand());
            this.attuneInflictorGem(entityLiving, source, entityLiving.getHeldItemOffhand());
        }
        this.applyInflictorGemResistance(event, entityLiving.getItemStackFromSlot(EntityEquipmentSlot.HEAD));
        this.applyInflictorGemResistance(event, entityLiving.getItemStackFromSlot(EntityEquipmentSlot.CHEST));
        this.applyInflictorGemResistance(event, entityLiving.getItemStackFromSlot(EntityEquipmentSlot.LEGS));
        this.applyInflictorGemResistance(event, entityLiving.getItemStackFromSlot(EntityEquipmentSlot.FEET));
        for (ItemStack s2 : entityLiving.getEquipmentAndArmor()) {
            if (!(s2.getItem() instanceof ItemArmor)) continue;
            this.addHeat(entityLiving, s2, 5.0f);
        }
        if (source.getTrueSource() instanceof EntityPlayer && !(s2 = (damager = (EntityPlayer)source.getTrueSource()).getHeldItemMainhand()).isEmpty()) {
            this.addHeat(entityLiving, s2, 1.0f);
        }
    }

    private void attuneInflictorGem(EntityLivingBase entityLiving, DamageSource source, ItemStack stack) {
        if (stack.getItem() instanceof IInflictorGem) {
            ((IInflictorGem)stack.getItem()).attuneSource(stack, entityLiving, source);
        }
    }

    private void applyInflictorGemResistance(LivingHurtEvent event, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IInflictorGemHolder) {
            IInflictorGemHolder inflictorGemHolder = (IInflictorGemHolder)item;
            float mult = Math.max(0.0f, 1.0f - inflictorGemHolder.getTotalDamageResistance(event.getEntityLiving(), event.getSource(), stack));
            if (mult == 0.0f) {
                event.setCanceled(true);
            }
            event.setAmount(event.getAmount() * mult);
        }
    }

    private void addHeat(EntityLivingBase entity, ItemStack stack, float added) {
        if (ItemModUtil.hasHeat(stack)) {
            double maxHeat = ItemModUtil.getMaxHeat(stack);
            double heat = ItemModUtil.getHeat(stack);
            if (heat < maxHeat) {
                ItemModUtil.addHeat(stack, added);
                if (heat + (double)added >= maxHeat) {
                    entity.getEntityWorld().playSound(null, entity.posX, entity.posY, entity.posZ, SoundManager.HEATED_ITEM_LEVELUP, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            World world;
            frameCounter += 1.0f;
            frameTime = (float)(System.nanoTime() - prevTime) / 1.0E9f;
            prevTime = System.nanoTime();
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            boolean showBar = false;
            int w = e.getResolution().getScaledWidth();
            int h = e.getResolution().getScaledHeight();
            int x = w / 2;
            int y = h / 2;
            if (!player.getHeldItemMainhand().isEmpty() && player.getHeldItemMainhand().getItem() instanceof ItemEmberGauge) {
                showBar = true;
            }
            if (!player.getHeldItemOffhand().isEmpty() && player.getHeldItemOffhand().getItem() instanceof ItemEmberGauge) {
                showBar = true;
            }
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder b = tess.getBuffer();
            if (showBar) {
                world = player.getEntityWorld();
                GlStateManager.disableDepth();
                GlStateManager.disableCull();
                GlStateManager.pushMatrix();
                Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("embers:textures/gui/ember_meter_overlay.png"));
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean offsetX = false;
                b.begin(7, DefaultVertexFormats.POSITION_TEX);
                RenderUtil.drawQuadGui(b, 0.0, x - 16, y - 4, x + 16, y - 4, x + 16, y - 36, x - 16, y - 36, 0.0, 0.0, 1.0, 1.0);
                tess.draw();
                double angle = 195.0;
                EmberWorldData data = EmberWorldData.get(world);
                if (player != null) {
                    double ratio = EmberGenUtil.getEmberDensity(world.getSeed(), player.getPosition().getX(), player.getPosition().getZ());
                    this.gaugeAngle = this.gaugeAngle == 0.0 ? 165.0 + 210.0 * ratio : this.gaugeAngle * 0.99 + 0.01 * (165.0 + 210.0 * ratio);
                }
                Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("embers:textures/gui/ember_meter_pointer.png"));
                GlStateManager.translate((float)x, (float)(y - 20), (float)0.0f);
                GlStateManager.rotate((float)((float)this.gaugeAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                b.begin(7, DefaultVertexFormats.POSITION_TEX);
                RenderUtil.drawQuadGui(b, 0.0, -2.5, 13.5, 13.5, 13.5, 13.5, -2.5, -2.5, -2.5, 0.0, 0.0, 1.0, 1.0);
                tess.draw();
                GlStateManager.popMatrix();
                GlStateManager.enableCull();
                GlStateManager.enableDepth();
            }
            world = player.getEntityWorld();
            RayTraceResult result = player.rayTrace(6.0, e.getPartialTicks());
            if (result != null && result.typeOfHit == RayTraceResult.Type.BLOCK) {
                TileEntity tileEntity;
                IBlockState state = world.getBlockState(result.getBlockPos());
                EnumFacing facing = result.sideHit;
                ArrayList text = Lists.newArrayList();
                if (state.getBlock() instanceof IDial) {
                    text.addAll(((IDial)state.getBlock()).getDisplayInfo(world, result.getBlockPos(), state));
                }
                if (Embers.proxy.isPlayerWearingGoggles() && (tileEntity = world.getTileEntity(result.getBlockPos())) != null) {
                    this.addCapabilityInformation(text, tileEntity, facing);
                }
                for (int i = 0; i < text.size(); ++i) {
                    Minecraft.getMinecraft().fontRenderer.drawStringWithShadow((String)text.get(i), (float)(x - Minecraft.getMinecraft().fontRenderer.getStringWidth((String)text.get(i)) / 2), (float)(y + 40 + 11 * i), 0xFFFFFF);
                }
            }
        }
        Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("minecraft:textures/gui/icons.png"));
        GlStateManager.enableDepth();
    }

    private void addCapabilityInformation(List<String> text, TileEntity tile, EnumFacing facing) {
        EventManager.addCapabilityItemDescription(text, tile, facing);
        EventManager.addCapabilityFluidDescription(text, tile, facing);
        EventManager.addCapabilityEmberDescription(text, tile, facing);
        if (Util.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.addCapabilityInformation(text, tile, facing);
        }
        if (tile.hasCapability(EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY, facing)) {
            text.add(I18n.format((String)"embers.tooltip.goggles.upgrade", (Object[])new Object[0]));
        }
        if (TileEntityMechAccessor.canAccess(tile)) {
            text.add(I18n.format((String)"embers.tooltip.goggles.accessor_slot", (Object[])new Object[0]));
        }
        if (tile instanceof IMechanicallyPowered) {
            text.add(I18n.format((String)"embers.tooltip.goggles.actuator_slot", (Object[])new Object[0]));
        }
        if (tile instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)tile).addOtherDescription(text, facing);
        }
    }

    public static void addCapabilityItemDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability capability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            String filter = null;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.item", filter));
            }
        }
    }

    public static void addCapabilityFluidDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability capability = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            String filter = null;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                IFluidHandler handler = (IFluidHandler)tile.getCapability(capability, facing);
                for (IFluidTankProperties properties : handler.getTankProperties()) {
                    boolean input = properties.canFill();
                    boolean output = properties.canDrain();
                    if (!input && !output) {
                        ioType = IExtraCapabilityInformation.EnumIOType.NONE;
                        continue;
                    }
                    if (input && !output) {
                        ioType = IExtraCapabilityInformation.EnumIOType.INPUT;
                        continue;
                    }
                    if (!output || input) continue;
                    ioType = IExtraCapabilityInformation.EnumIOType.OUTPUT;
                }
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.fluid", filter));
            }
        }
    }

    public static void addCapabilityEmberDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability<IEmberCapability> capability = EmbersCapabilities.EMBER_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.ember", null));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player;
            ++ticks;
            if (!Minecraft.getMinecraft().isGamePaused()) {
                ClientProxy.particleRenderer.updateParticles();
            }
            if ((player = Minecraft.getMinecraft().player) != null) {
                IBlockState state;
                World world = player.getEntityWorld();
                RayTraceResult result = player.rayTrace(6.0, Minecraft.getMinecraft().getRenderPartialTicks());
                if (result != null && result.typeOfHit == RayTraceResult.Type.BLOCK && (state = world.getBlockState(result.getBlockPos())).getBlock() instanceof IDial) {
                    ((IDial)state.getBlock()).updateTEData(world, state, result.getBlockPos());
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer() != null && (Minecraft.getMinecraft().inGameHasFocus || event.getEntityPlayer().getUniqueID().compareTo(Minecraft.getMinecraft().player.getUniqueID()) != 0)) {
            event.setCanceled(!allowPlayerRenderEvent);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamaged(LivingHurtEvent event) {
        Entity trueSource;
        if (event.getSource().damageType.equals(DamageSourceRegister.DAMAGE_EMBER.damageType) && event.getEntityLiving().isPotionActive(Potion.getPotionFromResourceLocation((String)"fire_resistance"))) {
            event.setAmount(event.getAmount() * 0.5f);
        }
        if (!((trueSource = event.getSource().getTrueSource()) instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)trueSource;
        ItemStack heldStack = player.getHeldItemMainhand();
        if (heldStack.isEmpty()) {
            return;
        }
        if (heldStack.getItem() == ItemRegister.TYRFING) {
            event.getEntity().playSound(SoundManager.TYRFING_HIT, 1.0f, 1.0f);
            if (!event.getEntity().world.isRemote) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTyrfingBurstFX(event.getEntity().posX, event.getEntity().posY + (double)(event.getEntity().height / 2.0f), event.getEntity().posZ));
            }
            event.setAmount(event.getAmount() / 4.0f * (4.0f + (float)event.getEntityLiving().getEntityAttribute(SharedMonsterAttributes.ARMOR).getAttributeValue()));
        }
        if (heldStack.getItem() instanceof IEmberChargedTool) {
            if (!player.capabilities.isCreativeMode && !((IEmberChargedTool)heldStack.getItem()).hasEmber(heldStack)) {
                event.setCanceled(true);
            }
            if (!event.isCanceled() && event.getAmount() > 0.0f) {
                event.getEntityLiving().setFire(1);
                if (!event.getEntityLiving().getEntityWorld().isRemote) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX(event.getEntityLiving().posX, event.getEntityLiving().posY + (double)event.getEntityLiving().getEyeHeight() / 1.5, event.getEntityLiving().posZ));
                    heldStack.getTagCompound().setBoolean("didUse", true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player != null && !player.getHeldItemMainhand().isEmpty()) {
            ItemStack s = player.getHeldItemMainhand();
            if (!s.isEmpty() && event.getState().getBlockHardness(event.getWorld(), event.getPos()) > 0.0f) {
                this.addHeat((EntityLivingBase)player, s, 1.0f);
            }
            if (player.getHeldItemMainhand().getItem() instanceof ItemGrandhammer) {
                event.setCanceled(true);
                event.getWorld().setBlockToAir(event.getPos());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onProjectileFired(EmberProjectileEvent event) {
        EntityLivingBase shooter = event.getShooter();
        ItemStack weapon = event.getStack();
        if (!weapon.isEmpty()) {
            this.addHeat(shooter, weapon, (float)event.getProjectiles().size() * (float)MathHelper.clampedLerp((double)0.5, (double)3.0, (double)event.getCharge()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowLoose(ArrowLooseEvent event) {
        EntityLivingBase shooter = event.getEntityLiving();
        ItemStack weapon = event.getBow();
        if (!weapon.isEmpty()) {
            this.addHeat(shooter, weapon, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (ItemModUtil.hasHeat(event.getItemStack())) {
            List<ModifierBase> modifiers;
            long count;
            event.getToolTip().add("");
            if (ItemModUtil.hasHeat(event.getItemStack()) && ItemModUtil.getLevel(event.getItemStack()) > 0) {
                event.getToolTip().add("");
            }
            event.getToolTip().add("                        ");
            if (ItemModUtil.hasHeat(event.getItemStack()) && (count = (modifiers = ItemModUtil.getModifiers(event.getItemStack())).stream().filter(x -> x.shouldRenderTooltip).count()) > 0L) {
                event.getToolTip().add(TextFormatting.GRAY + I18n.format((String)"embers.tooltip.modifiers", (Object[])new Object[0]));
                int i = 0;
                while ((long)i < count) {
                    event.getToolTip().add("");
                    ++i;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltipRender(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack != null && ItemModUtil.hasHeat(stack)) {
            for (int i = 0; i < event.getLines().size(); ++i) {
                float ref;
                int func;
                if (((String)event.getLines().get(i)).compareTo(TextFormatting.GRAY + "" + TextFormatting.GRAY + I18n.format((String)"embers.tooltip.modifiers", (Object[])new Object[0])) == 0) {
                    List modifiers = ItemModUtil.getModifiers(stack).stream().filter(x -> x.shouldRenderTooltip).collect(Collectors.toList());
                    GlStateManager.disableDepth();
                    GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    if (modifiers.size() > 0) {
                        GlStateManager.enableBlend();
                        GlStateManager.enableAlpha();
                        func = GL11.glGetInteger((int)3009);
                        ref = GL11.glGetFloat((int)3010);
                        GlStateManager.alphaFunc((int)519, (float)0.0f);
                        int j = 0;
                        for (ModifierBase modifier : modifiers) {
                            int level = ItemModUtil.getModifierLevel(stack, modifier);
                            GuiCodex.drawTextGlowingAura(event.getFontRenderer(), I18n.format((String)("embers.tooltip.modifier." + modifier.name), (Object[])new Object[]{this.getFormattedModifierLevel(level)}), event.getX(), event.getY() + (event.getFontRenderer().FONT_HEIGHT + 1) * (i + j + 1) + 2);
                            ++j;
                        }
                        GlStateManager.alphaFunc((int)func, (float)ref);
                        GlStateManager.disableAlpha();
                        GlStateManager.disableBlend();
                    }
                    GlStateManager.enableDepth();
                }
                if (((String)event.getLines().get(i)).compareTo(TextFormatting.GRAY + "                        ") != 0) continue;
                GlStateManager.disableDepth();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                if (ItemModUtil.getLevel(stack) > 0) {
                    event.getFontRenderer().drawStringWithShadow(TextFormatting.GRAY + I18n.format((String)"embers.tooltip.heat_level", (Object[])new Object[0]), (float)event.getX(), (float)(event.getY() + (event.getFontRenderer().FONT_HEIGHT + 1) * (i - 1) + 2), -1);
                    int level_x = event.getFontRenderer().getStringWidth(I18n.format((String)"embers.tooltip.heat_level", (Object[])new Object[0])) + 2;
                    GlStateManager.enableBlend();
                    GlStateManager.enableAlpha();
                    func = GL11.glGetInteger((int)3009);
                    ref = GL11.glGetFloat((int)3010);
                    GlStateManager.alphaFunc((int)519, (float)0.0f);
                    GuiCodex.drawTextGlowingAura(event.getFontRenderer(), "" + ItemModUtil.getLevel(stack), event.getX() + level_x, event.getY() + (event.getFontRenderer().FONT_HEIGHT + 1) * (i - 1) + 2);
                    GlStateManager.alphaFunc((int)func, (float)ref);
                    GlStateManager.disableAlpha();
                    GlStateManager.disableBlend();
                }
                event.getFontRenderer().drawStringWithShadow(TextFormatting.GRAY + I18n.format((String)"embers.tooltip.heat_amount", (Object[])new Object[0]), (float)event.getX(), (float)(event.getY() + (event.getFontRenderer().FONT_HEIGHT + 1) * i + 2), -1);
                double x2 = (double)event.getFontRenderer().getStringWidth(I18n.format((String)"embers.tooltip.heat_amount", (Object[])new Object[0])) + 1.0;
                double w = event.getFontRenderer().getStringWidth("                        ");
                Minecraft.getMinecraft().renderEngine.bindTexture(new ResourceLocation("embers:textures/gui/heat_bar.png"));
                Tessellator tess = Tessellator.getInstance();
                BufferBuilder b = tess.getBuffer();
                GlStateManager.disableTexture2D();
                GlStateManager.enableAlpha();
                int func2 = GL11.glGetInteger((int)3009);
                float ref2 = GL11.glGetFloat((int)3010);
                GlStateManager.alphaFunc((int)519, (float)0.0f);
                GlStateManager.enableBlend();
                double baseX = event.getX();
                double baseY = event.getY() + (event.getFontRenderer().FONT_HEIGHT + 1) * i + 2;
                GlStateManager.shadeModel((int)7425);
                b.begin(7, DefaultVertexFormats.POSITION_COLOR);
                double x1 = baseX + x2 + 4.0;
                double x22 = baseX + w - 3.0;
                float heat = ItemModUtil.getHeat(stack);
                float maxHeat = ItemModUtil.getMaxHeat(stack);
                x22 = x1 + (x22 - x1) * (double)(heat / maxHeat);
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double coeff = j / 10.0;
                    double coeff2 = (j + 1.0) / 10.0;
                    for (double k = 0.0; k < 4.0; k += 0.5) {
                        float thick = (float)(k / 4.0) * (heat >= maxHeat ? (float)Math.sin((double)ticks * 0.5) * 2.0f + 3.0f : 1.0f);
                        RenderUtil.drawColorRectBatched(b, x1 * (1.0 - coeff) + x22 * coeff, baseY + k, 0.0, (x22 - x1) / 10.0, 8.0 - 2.0 * k, 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + k))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + k))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + (8.0 - k)))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + (8.0 - k)))));
                    }
                }
                x1 = baseX + x2 + 4.0;
                x22 = baseX + w - 3.0;
                double point = x1 + (x22 - x1) * (double)(heat / maxHeat);
                for (double k = 0.0; k < 4.0; k += 0.5) {
                    float thick = (float)(k / 4.0);
                    RenderUtil.drawColorRectBatched(b, point, baseY + k, 0.0, Math.min(x22 - point, (x22 - x1) / 10.0), 8.0 - 2.0 * k, 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * point), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.0f, 0.25f, 0.0625f, 0.015625f, 0.0f, 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * point), 4 * (int)(baseY + (8.0 - k)))));
                }
                tess.draw();
                b.begin(7, DefaultVertexFormats.POSITION_COLOR);
                x1 = baseX + x2 + 4.0;
                x22 = baseX + w - 3.0;
                x1 = x22 - (x22 - x1) * (double)(1.0f - heat / maxHeat);
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double coeff = j / 10.0;
                    double coeff2 = (j + 1.0) / 10.0;
                    for (double k = 0.0; k < 4.0; k += 0.5) {
                        float thick = (float)(k / 4.0);
                        RenderUtil.drawColorRectBatched(b, x1 * (1.0 - coeff) + x22 * coeff, baseY + k, 0.0, (x22 - x1) / 10.0, 8.0 - 2.0 * k, 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + (8.0 - k)))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + (8.0 - k)))));
                    }
                }
                tess.draw();
                GlStateManager.shadeModel((int)7424);
                GlStateManager.enableTexture2D();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.alphaFunc((int)func2, (float)ref2);
                b.begin(7, DefaultVertexFormats.POSITION_TEX);
                RenderUtil.drawTexturedModalRectBatched(b, (int)(baseX + x2 + 1.0), (int)baseY - 1, 0.0, 0.0, 0.0, 0.5, 0.625, 8, 10);
                RenderUtil.drawTexturedModalRectBatched(b, (int)(baseX + w - 8.0), (int)baseY - 1, 0.0, 0.5, 0.0, 1.0, 0.625, 8, 10);
                tess.draw();
                GlStateManager.disableBlend();
                GlStateManager.disableAlpha();
                GlStateManager.enableDepth();
            }
        }
    }

    private String getFormattedModifierLevel(int level) {
        String key = "embers.tooltip.num" + level;
        if (I18n.hasKey((String)key)) {
            return I18n.format((String)key, (Object[])new Object[0]);
        }
        return I18n.format((String)"embers.tooltip.numstop", (Object[])new Object[0]);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderAfterWorld(RenderWorldLastEvent event) {
        tickCounter += 1.0f;
        if (Embers.proxy instanceof ClientProxy) {
            GlStateManager.pushMatrix();
            ClientProxy.particleRenderer.renderParticles(clientPlayer, event.getPartialTicks());
            GlStateManager.popMatrix();
        }
        List list = Minecraft.getMinecraft().world.loadedTileEntityList;
        GlStateManager.pushMatrix();
        for (int i = 0; i < list.size(); ++i) {
            TileEntitySpecialRenderer render = TileEntityRendererDispatcher.instance.getRenderer((TileEntity)list.get(i));
            if (!(render instanceof ITileEntitySpecialRendererLater)) continue;
            double x = Minecraft.getMinecraft().player.lastTickPosX + (double)Minecraft.getMinecraft().getRenderPartialTicks() * (Minecraft.getMinecraft().player.posX - Minecraft.getMinecraft().player.lastTickPosX);
            double y = Minecraft.getMinecraft().player.lastTickPosY + (double)Minecraft.getMinecraft().getRenderPartialTicks() * (Minecraft.getMinecraft().player.posY - Minecraft.getMinecraft().player.lastTickPosY);
            double z = Minecraft.getMinecraft().player.lastTickPosZ + (double)Minecraft.getMinecraft().getRenderPartialTicks() * (Minecraft.getMinecraft().player.posZ - Minecraft.getMinecraft().player.lastTickPosZ);
            ((ITileEntitySpecialRendererLater)render).renderLater((TileEntity)list.get(i), (double)((TileEntity)list.get(i)).getPos().getX() - x, (double)((TileEntity)list.get(i)).getPos().getY() - y, (double)((TileEntity)list.get(i)).getPos().getZ() - z, Minecraft.getMinecraft().getRenderPartialTicks());
        }
        GlStateManager.popMatrix();
    }

    @SubscribeEvent
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        event.getOriginalSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawScaledCustomSizeModalRect(double x, double y, float u, float v, float uWidth, float vHeight, double width, double height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder BufferBuilder2 = tessellator.getBuffer();
        BufferBuilder2.begin(7, DefaultVertexFormats.POSITION_TEX);
        BufferBuilder2.pos(x, y + height, 0.0).tex((double)(u * f), (double)((v + vHeight) * f1)).endVertex();
        BufferBuilder2.pos(x + width, y + height, 0.0).tex((double)((u + uWidth) * f), (double)((v + vHeight) * f1)).endVertex();
        BufferBuilder2.pos(x + width, y, 0.0).tex((double)((u + uWidth) * f), (double)(v * f1)).endVertex();
        BufferBuilder2.pos(x, y, 0.0).tex((double)(u * f), (double)(v * f1)).endVertex();
        tessellator.draw();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.toString();
            if (!removedItems.contains(path)) continue;
            entry.ignore();
        }
    }

    public static class ExplosionCharmWorldInfo {
        HashMultimap<ChunkPos, BlockPos> data = HashMultimap.create();

        public void put(BlockPos pos) {
            ChunkPos chunkPos = new ChunkPos(pos);
            this.data.put((Object)chunkPos, (Object)pos);
        }

        public BlockPos getClosestExplosionCharm(World world, BlockPos pos, int radius) {
            BlockPos chosen = null;
            double minDistance = Double.POSITIVE_INFINITY;
            ChunkPos chunkPosA = new ChunkPos(pos.add(-radius, 0, -radius));
            ChunkPos chunkPosB = new ChunkPos(pos.add(radius, 0, radius));
            for (int x = chunkPosA.x; x <= chunkPosB.x; ++x) {
                for (int z = chunkPosA.z; z <= chunkPosB.z; ++z) {
                    ChunkPos chunkPos = new ChunkPos(x, z);
                    Iterator iterator = this.data.get((Object)chunkPos).iterator();
                    while (iterator.hasNext()) {
                        BlockPos testpos = (BlockPos)iterator.next();
                        double testdist = testpos.distanceSq((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                        if (testdist >= minDistance || testdist > (double)(radius * radius)) continue;
                        TileEntity tile = world.getTileEntity(testpos);
                        if (tile instanceof TileEntityExplosionPedestal && !tile.isInvalid()) {
                            chosen = testpos;
                            minDistance = testdist;
                            continue;
                        }
                        iterator.remove();
                    }
                }
            }
            return chosen;
        }
    }
}

