/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import teamroots.embers.tileentity.TileEntityItemRequisition;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.PipeRenderUtil;

public class TileEntityItemRequisitionRenderer
extends TileEntitySpecialRenderer<TileEntityItemRequisition> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/item_pipe_tex.png");

    public void render(TileEntityItemRequisition tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            GlStateManager.func_179129_p();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buffer = tess.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (this.shouldRenderPipe(tile, facing)) {
                    PipeRenderUtil.addPipe(buffer, x, y, z, facing);
                }
                if (!this.shouldRenderLip(tile, facing)) continue;
                PipeRenderUtil.addPipeLip(buffer, x, y, z, facing);
            }
            tess.func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            GlStateManager.func_179089_o();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5));
            GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
            GL11.glRotated((double)(tile.angle + tile.turnRate * (double)partialTicks), (double)0.0, (double)1.0, (double)0.0);
            ItemStack filterItem = tile.filterItem;
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(filterItem, tile.func_145831_w(), null);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)0.1f, (float)0.0f, (float)0.0f, (float)0.1f);
            this.renderItem(filterItem, model);
            GL11.glPopMatrix();
        }
    }

    public void renderItem(ItemStack stack, IBakedModel model) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.5f;
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                Color color = new Color(r, g, b, a);
                Minecraft.func_71410_x().func_175599_af().func_191967_a(model, color.getRGB(), stack);
            }
            GlStateManager.func_179121_F();
        }
    }

    private boolean shouldRenderLip(TileEntityItemRequisition pipe, EnumFacing facing) {
        EnumPipeConnection connection = pipe.getInternalConnection(facing);
        return connection == EnumPipeConnection.BLOCK || connection == EnumPipeConnection.LEVER;
    }

    private boolean shouldRenderPipe(TileEntityItemRequisition pipe, EnumFacing facing) {
        EnumPipeConnection connection = pipe.getInternalConnection(facing);
        return connection == EnumPipeConnection.PIPE || this.shouldRenderLip(pipe, facing);
    }
}

