/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.event.MachineRecipeEvent;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityFurnaceTop;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityFurnaceBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
ISoundController {
    public static int PROCESS_TIME = ConfigMachine.MELTER.processTime;
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    int progress = -1;
    public static double EMBER_COST = ConfigMachine.MELTER.emberCost;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();
    boolean isWorking;
    private List<IUpgradeProvider> upgrades;

    public TileEntityFurnaceBottom() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        TileEntityFurnaceTop top = (TileEntityFurnaceTop)this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a());
        this.upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_176754_o);
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        if (top != null && !top.inventory.getStackInSlot(0).func_190926_b()) {
            boolean cancel;
            double emberCost = UpgradeUtil.getTotalEmberConsumption(this, EMBER_COST, this.upgrades);
            if (this.capability.getEmber() >= emberCost && !(cancel = UpgradeUtil.doWork(this, this.upgrades))) {
                ItemStack recipeStack;
                ItemMeltingRecipe recipe;
                UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), this.upgrades);
                this.capability.removeAmount(emberCost, true);
                if (this.field_145850_b.field_72995_K) {
                    if (this.random.nextInt(20) == 0) {
                        ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.25f, (float)this.func_174877_v().func_177952_p() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                    }
                    if (this.random.nextInt(10) == 0) {
                        for (int i = 0; i < 12; ++i) {
                            ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.25f, (float)this.func_174877_v().func_177952_p() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.0f, 0.03125f + 0.03125f * this.random.nextFloat(), 0.0f, 64.0f, 64.0f, 64.0f, 0.125f, 5.0f + 3.0f * this.random.nextFloat(), 80);
                        }
                    }
                }
                this.isWorking = true;
                ++this.progress;
                this.func_70296_d();
                if (this.progress >= UpgradeUtil.getWorkTime(this, PROCESS_TIME, this.upgrades) && (recipe = this.getRecipe(recipeStack = top.inventory.getStackInSlot(0))) != null && !this.field_145850_b.field_72995_K) {
                    FluidStack output = recipe.getResult(this, recipeStack);
                    FluidTank tank = top.getTank();
                    if ((output = UpgradeUtil.transformOutput((TileEntity)this, output, this.upgrades)) != null && tank.fill(output, false) >= output.amount) {
                        tank.fill(output, true);
                        top.func_70296_d();
                        top.inventory.extractItem(0, recipe.getInputConsumed(), false);
                        this.progress = 0;
                        UpgradeUtil.throwEvent(this, new MachineRecipeEvent.Success<ItemMeltingRecipe>(this, recipe), this.upgrades);
                        this.func_70296_d();
                    }
                }
            }
        } else {
            this.isWorking = false;
            if (this.progress > 0) {
                this.progress = 0;
                this.func_70296_d();
            }
        }
    }

    private ItemMeltingRecipe getRecipe(ItemStack recipeStack) {
        ItemMeltingRecipe recipe = RecipeRegistry.getMeltingRecipe(recipeStack);
        MachineRecipeEvent<ItemMeltingRecipe> event = new MachineRecipeEvent<ItemMeltingRecipe>(this, recipe);
        UpgradeUtil.throwEvent(this, event, this.upgrades);
        return event.getRecipe();
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.MELTER_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }
}

