/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.IFluidPipePriority;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.Misc;
import teamroots.embers.util.PipePriorityMap;

public abstract class TileEntityFluidPipeBase
extends TileEntity
implements ITileEntityBase,
ITickable,
IFluidPipeConnectable,
IFluidPipePriority {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    public static final int MAX_PUSH = 250;
    Random random = new Random();
    boolean[] from = new boolean[EnumFacing.field_82609_l.length];
    boolean clogged = false;
    public FluidTank tank;
    EnumFacing lastTransfer;
    boolean syncTank;
    boolean syncCloggedFlag;
    boolean syncTransfer;
    int ticksExisted;
    int lastRobin;

    protected TileEntityFluidPipeBase() {
        this.initFluidTank();
    }

    protected void initFluidTank() {
        this.tank = new FluidTank(this.getCapacity()){

            protected void onContentsChanged() {
                TileEntityFluidPipeBase.this.func_70296_d();
            }
        };
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.requiresSync()) {
            NBTTagCompound updateTag = this.getSyncTag();
            this.resetSync();
            return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    abstract int getCapacity();

    @Override
    public int getPriority(EnumFacing facing) {
        return 0;
    }

    public abstract EnumPipeConnection getInternalConnection(EnumFacing var1);

    abstract void setInternalConnection(EnumFacing var1, EnumPipeConnection var2);

    abstract boolean isConnected(EnumFacing var1);

    public void setFrom(EnumFacing facing, boolean flag) {
        this.from[facing.func_176745_a()] = flag;
    }

    public void resetFrom() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(EnumFacing facing) {
        return this.from[facing.func_176745_a()];
    }

    protected boolean isAnySideUnclogged() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile;
            if (!this.isConnected(facing) || !((tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) instanceof TileEntityFluidPipeBase) || ((TileEntityFluidPipeBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticksExisted;
            boolean fluidMoved = false;
            FluidStack passStack = this.tank.drain(250, false);
            if (passStack != null) {
                IFluidHandler handler;
                PipePriorityMap<Integer, EnumFacing> possibleDirections = new PipePriorityMap<Integer, EnumFacing>();
                IFluidHandler[] fluidHandlers = new IFluidHandler[EnumFacing.field_82609_l.length];
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TileEntity tile;
                    if (!this.isConnected(facing) || this.isFrom(facing) || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
                    handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                    int priority = 0;
                    if (tile instanceof IFluidPipePriority) {
                        priority = ((IFluidPipePriority)tile).getPriority(facing.func_176734_d());
                    }
                    if (this.isFrom(facing.func_176734_d())) {
                        priority -= 5;
                    }
                    possibleDirections.put(priority, facing);
                    fluidHandlers[facing.func_176745_a()] = handler;
                }
                Iterator iterator = possibleDirections.keySet().iterator();
                while (iterator.hasNext()) {
                    int key = (Integer)iterator.next();
                    ArrayList list = possibleDirections.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        EnumFacing facing = (EnumFacing)list.get((i + this.lastRobin) % list.size());
                        handler = fluidHandlers[facing.func_176745_a()];
                        fluidMoved = this.pushStack(passStack, facing, handler);
                        if (this.lastTransfer != facing) {
                            this.syncTransfer = true;
                            this.lastTransfer = facing;
                            this.func_70296_d();
                        }
                        if (!fluidMoved) continue;
                        ++this.lastRobin;
                        break;
                    }
                    if (!fluidMoved) continue;
                    break;
                }
            }
            if (this.tank.getFluidAmount() <= 0) {
                if (this.lastTransfer != null && !fluidMoved) {
                    this.syncTransfer = true;
                    this.lastTransfer = null;
                    this.func_70296_d();
                }
                fluidMoved = true;
                this.resetFrom();
            }
            if (this.clogged == fluidMoved) {
                this.clogged = !fluidMoved;
                this.syncCloggedFlag = true;
                this.func_70296_d();
            }
        } else if (Embers.proxy.isPlayerWearingGoggles() && this.lastTransfer != null) {
            for (int i = 0; i < 3; ++i) {
                float dist = this.random.nextFloat() * 0.0f;
                int lifetime = 10;
                float vx = (float)this.lastTransfer.func_82601_c() / ((float)lifetime / (1.0f - dist));
                float vy = (float)this.lastTransfer.func_96559_d() / ((float)lifetime / (1.0f - dist));
                float vz = (float)this.lastTransfer.func_82599_e() / ((float)lifetime / (1.0f - dist));
                float x = (float)this.field_174879_c.func_177958_n() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_82601_c() * dist;
                float y = (float)this.field_174879_c.func_177956_o() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_96559_d() * dist;
                float z = (float)this.field_174879_c.func_177952_p() + 0.4f + this.random.nextFloat() * 0.2f + (float)this.lastTransfer.func_82599_e() * dist;
                float r = this.clogged ? 255.0f : 16.0f;
                float g = this.clogged ? 16.0f : 255.0f;
                float b = 16.0f;
                float size = this.random.nextFloat() * 2.0f + 2.0f;
                ParticleUtil.spawnParticlePipeFlow(this.field_145850_b, x, y, z, vx, vy, vz, r, g, b, 0.5f, size, lifetime);
            }
        }
    }

    private boolean pushStack(FluidStack passStack, EnumFacing facing, IFluidHandler handler) {
        int added = handler.fill(passStack, false);
        if (added > 0) {
            handler.fill(passStack, true);
            this.tank.drain(added, true);
            passStack.amount -= added;
            return passStack.amount <= 0;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    protected void resetSync() {
        this.syncTank = false;
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
    }

    protected boolean requiresSync() {
        return this.syncTank || this.syncCloggedFlag || this.syncTransfer;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected NBTTagCompound getSyncTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.syncTank) {
            this.writeTank(compound);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(compound);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(compound);
        }
        return compound;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeTank(tag);
        this.writeCloggedFlag(tag);
        this.writeLastTransfer(tag);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            tag.func_74757_a("from" + facing.func_176745_a(), this.from[facing.func_176745_a()]);
        }
        tag.func_74768_a("lastRobin", this.lastRobin);
        return tag;
    }

    private void writeCloggedFlag(NBTTagCompound tag) {
        tag.func_74757_a("clogged", this.clogged);
    }

    private void writeLastTransfer(NBTTagCompound tag) {
        tag.func_74768_a("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    private void writeTank(NBTTagCompound tag) {
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("clogged")) {
            this.clogged = tag.func_74767_n("clogged");
        }
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT(tag.func_74775_l("tank"));
        }
        if (tag.func_74764_b("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(tag.func_74762_e("lastTransfer"));
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!tag.func_74764_b("from" + facing.func_176745_a())) continue;
            this.from[facing.func_176745_a()] = tag.func_74767_n("from" + facing.func_176745_a());
        }
        if (tag.func_74764_b("lastRobin")) {
            this.lastRobin = tag.func_74762_e("lastRobin");
        }
    }
}

