/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockCatalyticPlug;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeCatalyticPlug;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityCatalyticPlug
extends TileEntity
implements ITickable,
ITileEntityBase,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final int SOUND_OFF = 1;
    public static final int SOUND_ON = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    public static final int CAPACITY = ConfigMachine.CATALYTIC_PLUG.capacity;
    public int activeTicks = 0;
    public UpgradeCatalyticPlug upgrade;
    public FluidTank tank = new FluidTank(CAPACITY){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.getFluid((String)"alchemical_redstone");
        }
    };
    private Random random = new Random();
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityCatalyticPlug() {
        this.upgrade = new UpgradeCatalyticPlug(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74768_a("active", this.activeTicks);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.activeTicks = tag.func_74762_e("active");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockCatalyticPlug) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockCatalyticPlug.FACING);
        }
        return null;
    }

    public void setActive(int ticks) {
        this.activeTicks = Math.max(ticks, this.activeTicks);
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing() == facing;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFacing().func_176734_d() == facing || facing == null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing() == facing) {
            return (T)this.upgrade;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (this.getFacing().func_176734_d() == facing || facing == null)) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        --this.activeTicks;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.activeTicks > 0 && this.field_145850_b.field_72995_K && state.func_177230_c() instanceof BlockCatalyticPlug) {
            EnumFacing[] planars;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockCatalyticPlug.FACING);
            float yoffset = 0.4f;
            float wideoffset = 0.5f;
            Vec3d baseOffset = new Vec3d(0.5 - (double)((float)facing.func_82601_c() * yoffset), 0.5 - (double)((float)facing.func_96559_d() * yoffset), 0.5 - (double)((float)facing.func_82599_e() * yoffset));
            switch (facing.func_176740_k()) {
                case X: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Y: {
                    planars = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Z: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST};
                    break;
                }
                default: {
                    planars = null;
                }
            }
            for (void var10_10 : planars) {
                IBlockState sideState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a((EnumFacing)var10_10));
                if (sideState.func_193401_d((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a((EnumFacing)var10_10), var10_10.func_176734_d()) != BlockFaceShape.UNDEFINED) continue;
                float x = (float)this.func_174877_v().func_177958_n() + (float)baseOffset.field_72450_a + (float)var10_10.func_82601_c() * wideoffset;
                float y = (float)this.func_174877_v().func_177956_o() + (float)baseOffset.field_72448_b + (float)var10_10.func_96559_d() * wideoffset;
                float z = (float)this.func_174877_v().func_177952_p() + (float)baseOffset.field_72449_c + (float)var10_10.func_82599_e() * wideoffset;
                float motionx = (float)var10_10.func_82601_c() * 0.03f - (float)facing.func_82601_c() * 0.015f - 0.01f + this.random.nextFloat() * 0.02f;
                float motiony = (float)var10_10.func_96559_d() * 0.03f - (float)facing.func_96559_d() * 0.015f - 0.01f + this.random.nextFloat() * 0.02f;
                float motionz = (float)var10_10.func_82599_e() * 0.03f - (float)facing.func_82599_e() * 0.015f - 0.01f + this.random.nextFloat() * 0.02f;
                ParticleUtil.spawnParticleVapor(this.func_145831_w(), x, y, z, motionx, motiony, motionz, 255.0f, 16.0f, 16.0f, 1.0f, 1.0f, 2.0f, 24);
            }
        }
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.field_174879_c.func_177958_n() + 0.5f;
        float soundY = (float)this.field_174879_c.func_177956_o() + 0.5f;
        float soundZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
        switch (id) {
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.CATALYTIC_PLUG_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                this.field_145850_b.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundManager.CATALYTIC_PLUG_START, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.CATALYTIC_PLUG_LOOP_READY, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        if (id == 2) {
            this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundManager.CATALYTIC_PLUG_STOP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        boolean isWorking = this.activeTicks > 0;
        switch (id) {
            case 1: {
                return !isWorking && this.tank.getFluidAmount() > 0;
            }
            case 2: {
                return isWorking;
            }
        }
        return false;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        boolean isWorking = this.activeTicks > 0;
        switch (id) {
            case 1: {
                return !isWorking ? 1.0f : 0.0f;
            }
            case 2: {
                return isWorking ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType)) {
            information.clear();
            information.add(BlockFluidGauge.formatFluidStack(this.getFluidStack(), this.getCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.redstone", (Object[])new Object[0])));
        }
    }
}

