/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe.register;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.config.ConfigMachine;
import teamroots.embers.config.ConfigMisc;
import teamroots.embers.config.ConfigTool;
import teamroots.embers.recipe.BoreOutput;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.recipe.Util;
import teamroots.embers.recipe.register.IRegister;
import teamroots.embers.register.ItemRegister;
import teamroots.embers.util.AlchemyUtil;
import teamroots.embers.util.WeightedItemStack;

public class InitEarly
implements IRegister {
    public static final InitEarly INSTANCE = new InitEarly();

    private InitEarly() {
    }

    @Override
    public void execute() {
        Tuple<Ingredient, Double> result;
        String[] tokens;
        AlchemyUtil.registerAspect("iron", Ingredient.func_193367_a((Item)ItemRegister.ASPECTUS_IRON));
        AlchemyUtil.registerAspect("copper", Ingredient.func_193367_a((Item)ItemRegister.ASPECTUS_COPPER));
        AlchemyUtil.registerAspect("dawnstone", Ingredient.func_193367_a((Item)ItemRegister.ASPECTUS_DAWNSTONE));
        AlchemyUtil.registerAspect("lead", Ingredient.func_193367_a((Item)ItemRegister.ASPECTUS_LEAD));
        AlchemyUtil.registerAspect("silver", Ingredient.func_193367_a((Item)ItemRegister.ASPECTUS_SILVER));
        BoreOutput defaultOutput = new BoreOutput(Sets.newHashSet(), Sets.newHashSet(), Lists.newArrayList((Object[])new WeightedItemStack[]{new WeightedItemStack(new ItemStack(ItemRegister.CRYSTAL_EMBER), 20), new WeightedItemStack(new ItemStack(ItemRegister.SHARD_EMBER), 60), new WeightedItemStack(new ItemStack(ItemRegister.DUST_EMBER), 20)}));
        RecipeRegistry.setDefaultBoreOutput(defaultOutput);
        if (ConfigTool.METAL_TOOL.DAWNSTONE.register) {
            Ingredient anyDawnstoneTool = Ingredient.func_193368_a((Item[])new Item[]{ItemRegister.AXE_DAWNSTONE, ItemRegister.HOE_DAWNSTONE, ItemRegister.SWORD_DAWNSTONE, ItemRegister.SHOVEL_DAWNSTONE, ItemRegister.PICKAXE_DAWNSTONE});
            EmbersAPI.registerEmberToolEffeciency(anyDawnstoneTool, 2.0);
        }
        for (String s : ConfigMisc.ember_fuel) {
            tokens = s.split(";");
            Item fuel = Item.func_111206_d((String)tokens[0]);
            if (tokens.length != 2 || fuel == null) continue;
            EmbersAPI.registerEmberFuel(Ingredient.func_193367_a((Item)fuel), Integer.parseInt(tokens[1]));
        }
        for (String s : ConfigMisc.block_coefficient) {
            tokens = s.split(";");
            if (tokens.length != 2 || OreDictionary.getOres((String)tokens[0]).isEmpty()) continue;
            EmbersAPI.registerMetalCoefficient(tokens[0], Double.parseDouble(tokens[1]));
        }
        for (String s : ConfigMachine.COMBUSTOR.fuel) {
            result = Util.registerCoefficient(s);
            EmbersAPI.registerCombustionFuel((Ingredient)result.func_76341_a(), (Double)result.func_76340_b());
        }
        for (String s : ConfigMachine.CATALYZER.fuel) {
            result = Util.registerCoefficient(s);
            EmbersAPI.registerCatalysisFuel((Ingredient)result.func_76341_a(), (Double)result.func_76340_b());
        }
        EmbersAPI.registerBoilerFluid(FluidRegistry.WATER, FluidRegistry.getFluid((String)"steam"), 5.0, new Color(255, 255, 255));
        EmbersAPI.registerBoilerFluid(FluidRegistry.getFluid((String)"oil_dwarf"), FluidRegistry.getFluid((String)"gas_dwarf"), 1.0, new Color(192, 255, 128));
        EmbersAPI.registerSteamEngineFuel(FluidRegistry.getFluid((String)"steam"), 2.0, 1, new Color(255, 255, 255));
        EmbersAPI.registerSteamEngineFuel(FluidRegistry.getFluid((String)"gas_dwarf"), 2.5, 5, new Color(128, 192, 255));
    }
}

