/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.Comp;
import com.cleanroommc.groovyscript.api.documentation.annotations.Example;
import com.cleanroommc.groovyscript.api.documentation.annotations.MethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.Property;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderMethodDescription;
import com.cleanroommc.groovyscript.api.documentation.annotations.RecipeBuilderRegistrationMethod;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import groovyjarjarantlr4.v4.runtime.misc.Nullable;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.compat.groovyscript.GSPlugin;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@RegistryDescription(linkGenerator="embers")
public class Mixer
extends VirtualizedRegistry<FluidMixingRecipe> {
    @RecipeBuilderDescription(example={@Example(value=".fluidInput(fluid('water') * 100, fluid('lava') * 100).fluidOutput(fluid('dawnstone') * 100)")})
    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    @GroovyBlacklist
    public void onReload() {
        RecipeRegistry.mixingRecipes.removeAll(this.removeScripted());
        RecipeRegistry.mixingRecipes.addAll(this.restoreFromBackup());
    }

    public void add(FluidMixingRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            RecipeRegistry.mixingRecipes.add(recipe);
        }
    }

    public boolean remove(FluidMixingRecipe recipe) {
        if (RecipeRegistry.mixingRecipes.removeIf(r -> r == recipe)) {
            this.addBackup(recipe);
            return true;
        }
        return false;
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, example={@Example(value="fluid('dawnstone')")})
    public boolean removeByOutput(IIngredient output) {
        return RecipeRegistry.mixingRecipes.removeIf(r -> {
            if (output.test(r.getResult(r.getInput()))) {
                this.addBackup(r);
                return true;
            }
            return false;
        });
    }

    @MethodDescription(type=MethodDescription.Type.QUERY)
    public SimpleObjectStream<FluidMixingRecipe> streamRecipes() {
        return new SimpleObjectStream(RecipeRegistry.mixingRecipes).setRemover(this::remove);
    }

    @MethodDescription(type=MethodDescription.Type.REMOVAL, priority=2000, example={@Example(commented=true)})
    public void removeAll() {
        RecipeRegistry.mixingRecipes.forEach(arg_0 -> ((Mixer)this).addBackup(arg_0));
        RecipeRegistry.mixingRecipes.clear();
    }

    @Property.Properties(value={@Property(property="fluidInput", valid={@Comp(value="2", type=Comp.Type.GTE), @Comp(value="3", type=Comp.Type.LTE)}), @Property(property="fluidOutput", valid={@Comp(value="1")})})
    public static class RecipeBuilder
    extends AbstractRecipeBuilder<FluidMixingRecipe> {
        @Property(defaultValue="0.5", valid={@Comp(value="0", type=Comp.Type.GTE)}, value="groovyscript.wiki.embers.mixer.powerratio.value")
        private double powerRatio = 0.5;

        public String getErrorMsg() {
            return "Error adding Embers Mixing recipe";
        }

        @RecipeBuilderMethodDescription(field={"powerRatio"})
        public RecipeBuilder powerRatio(int powerRatio) {
            this.powerRatio = powerRatio;
            return this;
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg);
            this.validateFluids(msg, 2, 3, 1, 1);
            msg.add(this.powerRatio < 0.0, "Power ratio must be greater than or equal to 0, yet it was {}", new Object[]{this.powerRatio});
        }

        @RecipeBuilderRegistrationMethod
        @Nullable
        public FluidMixingRecipe register() {
            if (!this.validate()) {
                return null;
            }
            FluidMixingRecipe recipe = new FluidMixingRecipe((FluidStack[])this.fluidInput.toArray((Object[])new FluidStack[0]), (FluidStack)this.fluidOutput.get(0), this.powerRatio);
            GSPlugin.instance.mixer.add(recipe);
            return recipe;
        }
    }
}

