/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

public class ShaderUtil {
    public static int currentProgram = 0;
    public static int lightProgram = 0;
    public static int fastLightProgram = 0;

    public static void init() {
        lightProgram = ShaderUtil.loadProgram("/assets/embers/shaders/fastlight.vs", "/assets/embers/shaders/fastlight.fs");
        fastLightProgram = ShaderUtil.loadProgram("/assets/embers/shaders/fastlight.vs", "/assets/embers/shaders/fastlight.fs");
    }

    public static int loadProgram(String vsh, String fsh) {
        int vertexShader = ShaderUtil.createShader(vsh, OpenGlHelper.GL_VERTEX_SHADER);
        int fragmentShader = ShaderUtil.createShader(fsh, OpenGlHelper.GL_FRAGMENT_SHADER);
        int program = OpenGlHelper.glCreateProgram();
        OpenGlHelper.glAttachShader((int)program, (int)vertexShader);
        OpenGlHelper.glAttachShader((int)program, (int)fragmentShader);
        OpenGlHelper.glLinkProgram((int)program);
        return program;
    }

    public static void useProgram(int program) {
        OpenGlHelper.glUseProgram((int)program);
        currentProgram = program;
    }

    public static int createShader(String filename, int shaderType) {
        int shader = OpenGlHelper.glCreateShader((int)shaderType);
        if (shader == 0) {
            return 0;
        }
        try {
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderUtil.readFileAsString(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OpenGlHelper.glCompileShader((int)shader);
        OpenGlHelper.glCompileShader((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)OpenGlHelper.GL_COMPILE_STATUS) == 0) {
            throw new RuntimeException("Error creating shader: " + ShaderUtil.getLogInfo(shader));
        }
        return shader;
    }

    public static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static String readFileAsString(String filename) throws Exception {
        System.out.println("Loading shader [" + filename + "]...");
        StringBuilder source = new StringBuilder();
        InputStream in = ShaderUtil.class.getResourceAsStream(filename);
        String s = "";
        if (in != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                s = reader.lines().collect(Collectors.joining("\n"));
            }
        }
        return s;
    }
}

