/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import teamroots.embers.tileentity.IFluidPipeConnectable;
import teamroots.embers.tileentity.TileEntityMiniBoiler;
import teamroots.embers.util.EnumPipeConnection;
import teamroots.embers.util.PipeRenderUtil;

public class TileEntityMiniBoilerRenderer
extends TileEntitySpecialRenderer<TileEntityMiniBoiler> {
    public ResourceLocation texture = new ResourceLocation("embers:textures/blocks/pipe_tex.png");

    public void render(TileEntityMiniBoiler tile, double x, double y, double z, float partialTicks, int destroyStage, float tileAlpha) {
        if (tile != null) {
            Minecraft.getMinecraft().renderEngine.bindTexture(this.texture);
            GlStateManager.disableCull();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tessellator tess = Tessellator.getInstance();
            BufferBuilder buffer = tess.getBuffer();
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX_COLOR_NORMAL);
            for (EnumFacing facing : EnumFacing.HORIZONTALS) {
                if (this.shouldRenderPipe(tile, facing)) {
                    PipeRenderUtil.addPipe(buffer, x, y, z, facing);
                }
                if (!this.shouldRenderLip(tile, facing)) continue;
                PipeRenderUtil.addPipeLip(buffer, x, y, z, facing);
            }
            tess.draw();
            GlStateManager.enableCull();
        }
    }

    private EnumPipeConnection getPipeConnection(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.getTileEntity(pos.offset(facing));
        if (tile instanceof IFluidPipeConnectable) {
            return ((IFluidPipeConnectable)tile).getConnection(facing.getOpposite());
        }
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.getOpposite())) {
            return EnumPipeConnection.BLOCK;
        }
        return EnumPipeConnection.NONE;
    }

    private boolean shouldRenderLip(TileEntityMiniBoiler pipe, EnumFacing facing) {
        EnumPipeConnection connection = this.getPipeConnection(pipe.getWorld(), pipe.getPos(), facing);
        return connection == EnumPipeConnection.BLOCK || connection == EnumPipeConnection.LEVER;
    }

    private boolean shouldRenderPipe(TileEntityMiniBoiler pipe, EnumFacing facing) {
        EnumPipeConnection connection = this.getPipeConnection(pipe.getWorld(), pipe.getPos(), facing);
        return connection == EnumPipeConnection.PIPE || this.shouldRenderLip(pipe, facing);
    }
}

